/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.dcache.nfs.BackendServer;
import org.dcache.nfs.IoChannelCache;
import org.dcache.nfs.Mirror;
import org.dcache.nfs.Utils;
import org.dcache.nfs.zk.ZkDataServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataServer.class);
    private static final String PNFS_DS_ADDRESS = "PNFS_DS_ADDRESS";
    private CuratorFramework zkCurator;
    private int port;
    private int bepPort;
    private InetSocketAddress[] localInetAddresses;
    private String zkNode;
    private IoChannelCache fsc;
    private String idFile;
    private BackendServer bepSrv;

    public void setBepPort(int port) {
        this.bepPort = port;
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.zkCurator = curatorFramework;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void init() throws Exception {
        this.localInetAddresses = this.getLocalOrConfiguredAddresses(this.port);
        this.bepSrv = new BackendServer(this.bepPort, this.fsc);
        InetSocketAddress[] bep = Utils.getLocalAddresses(this.bepPort);
        UUID myId = DataServer.getOrAllocateId(this.idFile);
        Mirror mirror = new Mirror(myId, this.localInetAddresses, bep);
        this.zkNode = (String)((ACLBackgroundPathAndBytesable)this.zkCurator.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(ZKPaths.makePath((String)"/nfs/pnfs", (String)("ds-" + myId)), ZkDataServer.toBytes(mirror));
    }

    public void setIoChannelCache(IoChannelCache fsCache) {
        this.fsc = fsCache;
    }

    public void setIdFile(String path) {
        this.idFile = path;
    }

    public void destroy() throws Exception {
        this.bepSrv.shutdown();
        this.zkCurator.delete().forPath(this.zkNode);
    }

    private InetSocketAddress[] getLocalOrConfiguredAddresses(int port) throws SocketException {
        String suppliedAddress = System.getProperty(PNFS_DS_ADDRESS);
        if (Strings.isNullOrEmpty((String)suppliedAddress)) {
            return Utils.getLocalAddresses(port);
        }
        return (InetSocketAddress[])Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)suppliedAddress).stream().map(InetAddresses::forUriString).map(a -> new InetSocketAddress((InetAddress)a, port)).toArray(InetSocketAddress[]::new);
    }

    public static UUID getOrAllocateId(String idFile) throws IOException {
        Path p = new File(idFile).toPath();
        if (Files.isRegularFile(p, new LinkOption[0])) {
            return UUID.fromString(Files.readString(p));
        }
        if (Files.exists(p, new LinkOption[0])) {
            throw new FileAlreadyExistsException("Path exists and not a regular file");
        }
        UUID id = UUID.randomUUID();
        Files.writeString(p, (CharSequence)id.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
        return id;
    }
}

