/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Splitter;
import com.google.protobuf.ByteString;
import com.hazelcast.core.IMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.Mirror;
import org.dcache.nfs.Utils;
import org.dcache.nfs.bep.DataServerBepServiceGrpc;
import org.dcache.nfs.bep.RemoveFileRequest;
import org.dcache.nfs.bep.RemoveFileResponse;
import org.dcache.nfs.bep.SetFileSizeRequest;
import org.dcache.nfs.bep.SetFileSizeResponse;
import org.dcache.nfs.chimera.ChimeraVfs;
import org.dcache.nfs.nfsstat;
import org.dcache.nfs.status.DelayException;
import org.dcache.nfs.status.LayoutTryLaterException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.UnknownLayoutTypeException;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.FlexFileLayoutDriver;
import org.dcache.nfs.v4.Layout;
import org.dcache.nfs.v4.LayoutDriver;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NfsV41FileLayoutDriver;
import org.dcache.nfs.v4.Stateids;
import org.dcache.nfs.v4.ff.ff_layoutreturn4;
import org.dcache.nfs.v4.xdr.GETDEVICEINFO4args;
import org.dcache.nfs.v4.xdr.GETDEVICELIST4args;
import org.dcache.nfs.v4.xdr.LAYOUTCOMMIT4args;
import org.dcache.nfs.v4.xdr.LAYOUTERROR4args;
import org.dcache.nfs.v4.xdr.LAYOUTGET4args;
import org.dcache.nfs.v4.xdr.LAYOUTRETURN4args;
import org.dcache.nfs.v4.xdr.LAYOUTSTATS4args;
import org.dcache.nfs.v4.xdr.device_addr4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.layout4;
import org.dcache.nfs.v4.xdr.layouttype4;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.offset4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.utf8str_mixed;
import org.dcache.nfs.vfs.ForwardingFileSystem;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VfsCache;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.nfs.zk.ZkDataServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeviceManager
extends ForwardingFileSystem
implements NFSv41DeviceManager {
    private static final Logger _log = LoggerFactory.getLogger(DeviceManager.class);
    private final Map<deviceid4, DS> _deviceMap = new ConcurrentHashMap<deviceid4, DS>();
    private final Map<stateid4, NFS4State> _openToLayoutStateid = new ConcurrentHashMap<stateid4, NFS4State>();
    private CuratorFramework zkCurator;
    private PathChildrenCache dsNodeCache;
    private final Map<layouttype4, LayoutDriver> _supportedDrivers;
    private IMap<byte[], byte[]> mdsStateIdCache;
    @Autowired(required=false)
    private BiConsumer<CompoundContext, ff_layoutreturn4> layoutStats = (c, s) -> {};
    private ChimeraVfs fs;
    private VfsCache fsCache;

    public DeviceManager() {
        this._supportedDrivers = new EnumMap<layouttype4, LayoutDriver>(layouttype4.class);
    }

    public void setChimeraVfs(ChimeraVfs fs) {
        this.fs = fs;
    }

    public void setVfs(VfsCache fs) {
        this.fsCache = fs;
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.zkCurator = curatorFramework;
    }

    public void setLayoutReturnConsumer(BiConsumer<CompoundContext, ff_layoutreturn4> layoutStats) {
        this.layoutStats = layoutStats;
    }

    public void setOpenStateidCache(IMap<byte[], byte[]> openStateIdCache) {
        this.mdsStateIdCache = openStateIdCache;
    }

    public void init() throws Exception {
        this._supportedDrivers.put(layouttype4.LAYOUT4_FLEX_FILES, (LayoutDriver)new FlexFileLayoutDriver(4, 1, 2, new utf8str_mixed("17"), new utf8str_mixed("17"), this.layoutStats));
        this._supportedDrivers.put(layouttype4.LAYOUT4_NFSV4_1_FILES, (LayoutDriver)new NfsV41FileLayoutDriver());
        this.dsNodeCache = new PathChildrenCache(this.zkCurator, "/nfs/pnfs", true);
        this.dsNodeCache.getListenable().addListener((c, e) -> {
            switch (e.getType()) {
                case CHILD_ADDED: 
                case CHILD_UPDATED: {
                    _log.info("Adding DS: {}", (Object)e.getData().getPath());
                    this.addDS(e.getData().getPath());
                    break;
                }
                case CHILD_REMOVED: {
                    _log.info("Removing DS: {}", (Object)e.getData().getPath());
                    this.removeDS(e.getData().getPath());
                }
            }
        });
        this.dsNodeCache.start();
    }

    public Layout layoutGet(CompoundContext context, LAYOUTGET4args args) throws IOException {
        NFS4Client client = context.getSession().getClient();
        stateid4 stateid = Stateids.getCurrentStateidIfNeeded((CompoundContext)context, (stateid4)args.loga_stateid);
        NFS4State nfsState = client.state(stateid);
        Inode inode = context.currentInode();
        layouttype4 layoutType = layouttype4.valueOf((int)args.loga_layout_type);
        LayoutDriver layoutDriver = this.getLayoutDriver(layoutType);
        deviceid4[] deviceId = this.getOrBindDeviceId(inode, args.loga_iomode, layoutType);
        NFS4State openState = nfsState.getOpenState();
        stateid4 rawOpenState = openState.stateid();
        NFS4State layoutStateId = this._openToLayoutStateid.get(rawOpenState);
        if (layoutStateId == null) {
            layoutStateId = client.createState(openState.getStateOwner(), openState);
            this._openToLayoutStateid.put(stateid, layoutStateId);
            this.mdsStateIdCache.put((Object)rawOpenState.other, (Object)context.currentInode().toNfsHandle());
            nfsState.addDisposeListener(state -> {
                this._openToLayoutStateid.remove(rawOpenState);
                this.mdsStateIdCache.remove((Object)rawOpenState.other);
            });
        }
        layoutStateId.bumpSeqid();
        nfs_fh4 fh = new nfs_fh4(context.currentInode().toNfsHandle());
        layout4 layout = new layout4();
        layout.lo_iomode = args.loga_iomode;
        layout.lo_offset = new offset4(0L);
        layout.lo_length = new length4(-1L);
        layout.lo_content = layoutDriver.getLayoutContent(rawOpenState, 0x400000, fh, deviceId);
        return new Layout(true, layoutStateId.stateid(), new layout4[]{layout});
    }

    public device_addr4 getDeviceInfo(CompoundContext context, GETDEVICEINFO4args args) throws ChimeraNFSException {
        deviceid4 deviceId = args.gdia_device_id;
        layouttype4 layoutType = layouttype4.valueOf((int)args.gdia_layout_type);
        _log.debug("lookup for device: {}, type: {}", (Object)deviceId, (Object)layoutType);
        DS ds = this._deviceMap.get(deviceId);
        if (ds == null) {
            throw new NoEntException("Unknown device id: " + deviceId);
        }
        InetSocketAddress[] addrs = ds.getMultipathAddresses();
        InetAddress clientAddress = context.getRemoteSocketAddress().getAddress();
        InetSocketAddress[] effectiveAddresses = (InetSocketAddress[])Stream.of(addrs).filter(a -> !a.getAddress().isLoopbackAddress() || clientAddress.isLoopbackAddress()).filter(a -> !a.getAddress().isLinkLocalAddress() || clientAddress.isLinkLocalAddress()).filter(a -> !a.getAddress().isSiteLocalAddress() || clientAddress.isSiteLocalAddress()).toArray(InetSocketAddress[]::new);
        LayoutDriver layoutDriver = this.getLayoutDriver(layoutType);
        return layoutDriver.getDeviceAddress(effectiveAddresses);
    }

    public List<deviceid4> getDeviceList(CompoundContext context, GETDEVICELIST4args args) {
        return new ArrayList<deviceid4>(this._deviceMap.keySet());
    }

    public void layoutReturn(CompoundContext context, LAYOUTRETURN4args args) throws ChimeraNFSException {
        if (args.lora_layoutreturn.lr_returntype == 1) {
            stateid4 stateid = Stateids.getCurrentStateidIfNeeded((CompoundContext)context, (stateid4)args.lora_layoutreturn.lr_layout.lrf_stateid);
            layouttype4 layoutType = layouttype4.valueOf((int)args.lora_layout_type);
            _log.debug("release device for stateid {}", (Object)stateid);
            NFS4Client client = context.getSession().getClient();
            NFS4State layoutState = client.state(stateid);
            this._openToLayoutStateid.remove(layoutState.getOpenState().stateid());
            this.getLayoutDriver(layoutType).acceptLayoutReturnData(context, args.lora_layoutreturn.lr_layout.lrf_body);
        }
    }

    public OptionalLong layoutCommit(CompoundContext context, LAYOUTCOMMIT4args args) throws IOException {
        Stat stat;
        long currentSize;
        long newSize;
        Inode inode = context.currentInode();
        if (args.loca_last_write_offset.no_newoffset && (newSize = args.loca_last_write_offset.no_offset.value + 1L) > (currentSize = (stat = this.fs.getattr(inode)).getSize())) {
            Stat newStat = new Stat();
            newStat.setSize(newSize);
            this.fs.setattr(inode, newStat);
            this.fsCache.invalidateStatCache(inode);
            return OptionalLong.of(newSize);
        }
        return OptionalLong.empty();
    }

    public void layoutStats(CompoundContext contex, LAYOUTSTATS4args args) throws IOException {
    }

    public void layoutError(CompoundContext contex, LAYOUTERROR4args args) throws IOException {
    }

    private LayoutDriver getLayoutDriver(layouttype4 layoutType) throws UnknownLayoutTypeException {
        LayoutDriver layoutDriver = this._supportedDrivers.get(layoutType);
        if (layoutDriver == null) {
            throw new UnknownLayoutTypeException("Unsupported Layout type: " + layoutType);
        }
        return layoutDriver;
    }

    public Set<layouttype4> getLayoutTypes() {
        return this._supportedDrivers.keySet();
    }

    private void addDS(String node) throws Exception {
        byte[] data = (byte[])this.zkCurator.getData().forPath(node);
        Mirror mirror = ZkDataServer.stringToString(data);
        DS ds = new DS(mirror);
        this._deviceMap.put(Utils.deviceidOf(mirror.getId()), ds);
    }

    private void removeDS(String node) throws Exception {
        String id = node.substring("ds-".length() + "/nfs/pnfs".length() + 1);
        UUID deviceId = UUID.fromString(id);
        this._deviceMap.remove(Utils.deviceidOf(deviceId));
    }

    private deviceid4[] getBoundDeviceId(Inode inode) throws ChimeraNFSException, IOException {
        String combinedLocation = this.fs.getInodeLayout(inode);
        if (combinedLocation != null) {
            return (deviceid4[])Splitter.on((char)':').splitToList((CharSequence)combinedLocation).stream().map(UUID::fromString).map(Utils::deviceidOf).toArray(deviceid4[]::new);
        }
        return new deviceid4[0];
    }

    private deviceid4[] getOrBindDeviceId(Inode inode, int iomode, layouttype4 layoutType) throws ChimeraNFSException, IOException {
        deviceid4[] deviceId = this.getBoundDeviceId(inode);
        if (deviceId.length == 0) {
            if (iomode == 1) {
                throw new LayoutTryLaterException("No location");
            }
            int mirrors = layoutType == layouttype4.LAYOUT4_FLEX_FILES ? 2 : 1;
            deviceId = (deviceid4[])((Stream)this._deviceMap.keySet().stream().unordered()).limit(mirrors).toArray(deviceid4[]::new);
            if (deviceId.length == 0) {
                throw new LayoutTryLaterException("No dataservers available");
            }
            String combinedLocation = Arrays.asList(deviceId).stream().map(Utils::uuidOf).map(Object::toString).collect(Collectors.joining(":"));
            if (!this.fs.setInodeLayout(inode, combinedLocation)) {
                return this.getOrBindDeviceId(inode, iomode, layoutType);
            }
        }
        return deviceId;
    }

    public void setattr(Inode inode, Stat stat) throws IOException {
        if (stat.isDefined(Stat.StatAttribute.SIZE)) {
            deviceid4[] ids;
            for (deviceid4 id : ids = this.getOrBindDeviceId(inode, 2, layouttype4.LAYOUT4_NFSV4_1_FILES)) {
                DS ds = this._deviceMap.get(id);
                if (ds == null) {
                    _log.warn("No such DS: {}", (Object)id);
                    throw new DelayException("Not all data servers online");
                }
                ds.setFileSize(inode, stat.getSize());
            }
        }
        this.delegate().setattr(inode, stat);
    }

    public void remove(Inode parent, String nanme) throws IOException {
        Inode inode = this.lookup(parent, nanme);
        super.remove(parent, nanme);
        for (deviceid4 id : this.getBoundDeviceId(inode)) {
            DS ds = this._deviceMap.get(id);
            if (ds == null) {
                _log.warn("No such DS: {}", (Object)id);
                throw new DelayException("Not all data servers online");
            }
            ds.removeFile(inode);
        }
    }

    protected VirtualFileSystem delegate() {
        return this.fs;
    }

    private static class DS {
        private final ManagedChannel channel;
        private final DataServerBepServiceGrpc.DataServerBepServiceBlockingStub blockingStub;
        private final InetSocketAddress[] addr;

        DS(Mirror mirror) {
            this.addr = mirror.getMultipath();
            this.channel = ManagedChannelBuilder.forAddress((String)mirror.getBepAddress()[0].getAddress().getHostAddress(), (int)mirror.getBepAddress()[0].getPort()).usePlaintext().build();
            this.blockingStub = DataServerBepServiceGrpc.newBlockingStub((Channel)this.channel);
        }

        void setFileSize(Inode inode, long size) throws ChimeraNFSException {
            SetFileSizeRequest request = SetFileSizeRequest.newBuilder().setFh(ByteString.copyFrom((byte[])inode.toNfsHandle())).setSize(size).build();
            SetFileSizeResponse response = this.blockingStub.setFileSize(request);
            nfsstat.throwIfNeeded((int)response.getStatus());
        }

        void removeFile(Inode inode) throws ChimeraNFSException {
            RemoveFileRequest request = RemoveFileRequest.newBuilder().setFh(ByteString.copyFrom((byte[])inode.toNfsHandle())).build();
            RemoveFileResponse response = this.blockingStub.removeFile(request);
            nfsstat.throwIfNeeded((int)response.getStatus());
        }

        InetSocketAddress[] getMultipathAddresses() {
            return this.addr;
        }
    }
}

