/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.hazelcast.core.IMap;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.IoChannelCache;
import org.dcache.nfs.status.BadHandleException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.AbstractOperationExecutor;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationBIND_CONN_TO_SESSION;
import org.dcache.nfs.v4.OperationCREATE_SESSION;
import org.dcache.nfs.v4.OperationDESTROY_CLIENTID;
import org.dcache.nfs.v4.OperationDESTROY_SESSION;
import org.dcache.nfs.v4.OperationEXCHANGE_ID;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.OperationILLEGAL;
import org.dcache.nfs.v4.OperationPUTFH;
import org.dcache.nfs.v4.OperationPUTROOTFH;
import org.dcache.nfs.v4.OperationRECLAIM_COMPLETE;
import org.dcache.nfs.v4.OperationSEQUENCE;
import org.dcache.nfs.v4.xdr.COMMIT4res;
import org.dcache.nfs.v4.xdr.COMMIT4resok;
import org.dcache.nfs.v4.xdr.READ4res;
import org.dcache.nfs.v4.xdr.READ4resok;
import org.dcache.nfs.v4.xdr.WRITE4res;
import org.dcache.nfs.v4.xdr.WRITE4resok;
import org.dcache.nfs.v4.xdr.count4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.oncrpc4j.rpc.OncRpcException;

public class EDSNFSv4OperationFactory
extends AbstractOperationExecutor {
    private final IMap<byte[], byte[]> mdsStateIdCache;
    private final IoChannelCache fsc;

    public EDSNFSv4OperationFactory(IMap<byte[], byte[]> openStateIdCache, IoChannelCache fc) {
        this.mdsStateIdCache = openStateIdCache;
        this.fsc = fc;
    }

    protected AbstractNFSv4Operation getOperation(nfs_argop4 op) {
        switch (op.argop) {
            case 5: {
                return new DSOperationCOMMIT(op);
            }
            case 9: {
                return new OperationGETATTR(op);
            }
            case 22: {
                return new OperationPUTFH(op);
            }
            case 24: {
                return new OperationPUTROOTFH(op);
            }
            case 25: {
                return new DSOperationREAD(op);
            }
            case 38: {
                return new DSOperationWRITE(op);
            }
            case 42: {
                return new OperationEXCHANGE_ID(op);
            }
            case 43: {
                return new OperationCREATE_SESSION(op);
            }
            case 44: {
                return new OperationDESTROY_SESSION(op);
            }
            case 53: {
                return new OperationSEQUENCE(op);
            }
            case 58: {
                return new OperationRECLAIM_COMPLETE(op);
            }
            case 41: {
                return new OperationBIND_CONN_TO_SESSION(op);
            }
            case 57: {
                return new OperationDESTROY_CLIENTID(op);
            }
        }
        return new OperationILLEGAL(op);
    }

    private class DSOperationCOMMIT
    extends AbstractNFSv4Operation {
        public DSOperationCOMMIT(nfs_argop4 args) {
            super(args, 5);
        }

        public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
            COMMIT4res res = result.opcommit;
            Inode inode = context.currentInode();
            RandomAccessFile out = EDSNFSv4OperationFactory.this.fsc.get(inode);
            out.getFD().sync();
            res.status = 0;
            res.resok4 = new COMMIT4resok();
            res.resok4.writeverf = context.getRebootVerifier();
        }
    }

    private class DSOperationREAD
    extends AbstractNFSv4Operation {
        public DSOperationREAD(nfs_argop4 args) {
            super(args, 25);
        }

        public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
            READ4res res = result.opread;
            Inode inode = context.currentInode();
            stateid4 stateid = this._args.opread.stateid;
            byte[] fh = (byte[])EDSNFSv4OperationFactory.this.mdsStateIdCache.get((Object)stateid.other);
            if (fh == null) {
                throw new BadStateidException();
            }
            if (!Arrays.equals(fh, inode.toNfsHandle())) {
                throw new BadHandleException();
            }
            boolean eof = false;
            long offset = this._args.opread.offset.value;
            int count = this._args.opread.count.value;
            ByteBuffer bb = ByteBuffer.allocateDirect(count);
            FileChannel in = EDSNFSv4OperationFactory.this.fsc.get(inode).getChannel();
            int bytesReaded = in.read(bb, offset);
            bb.flip();
            if (bytesReaded < 0) {
                eof = true;
            }
            res.status = 0;
            res.resok4 = new READ4resok();
            res.resok4.data = bb;
            res.resok4.eof = eof;
        }
    }

    private class DSOperationWRITE
    extends AbstractNFSv4Operation {
        public DSOperationWRITE(nfs_argop4 args) {
            super(args, 38);
        }

        public void process(CompoundContext context, nfs_resop4 result) throws IOException {
            WRITE4res res = result.opwrite;
            long offset = this._args.opwrite.offset.value;
            this._args.opwrite.offset.checkOverflow(this._args.opwrite.data.remaining(), "offset + length overflow");
            Inode inode = context.currentInode();
            stateid4 stateid = this._args.opwrite.stateid;
            byte[] fh = (byte[])EDSNFSv4OperationFactory.this.mdsStateIdCache.get((Object)stateid.other);
            if (fh == null) {
                throw new BadStateidException();
            }
            if (!Arrays.equals(fh, inode.toNfsHandle())) {
                throw new BadHandleException();
            }
            FileChannel out = EDSNFSv4OperationFactory.this.fsc.get(inode).getChannel();
            this._args.opwrite.data.rewind();
            int bytesWritten = out.write(this._args.opwrite.data, offset);
            if (bytesWritten < 0) {
                throw new NfsIoException("IO not allowd");
            }
            res.status = 0;
            res.resok4 = new WRITE4resok();
            res.resok4.count = new count4(bytesWritten);
            res.resok4.committed = 1;
            res.resok4.writeverf = context.getRebootVerifier();
        }
    }
}

