/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Splitter;
import java.io.IOException;
import org.dcache.auth.Subjects;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class ExportPathCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportPathCreator.class);
    private ExportFile exportFile;
    private VirtualFileSystem vfs;

    public void setVfs(VirtualFileSystem vfs) {
        this.vfs = vfs;
    }

    public void setExportFile(ExportFile exportFile) {
        this.exportFile = exportFile;
    }

    private static Inode tryToCreateIfMissing(VirtualFileSystem vfs, Inode inode, String name) throws IOException {
        try {
            return vfs.lookup(inode, name);
        }
        catch (NoEntException e) {
            return vfs.mkdir(inode, name, Subjects.ROOT, 511);
        }
    }

    public void init() throws IOException {
        ExportPathCreator.registerSignalHandler(this.exportFile);
        Inode root = this.vfs.getRootInode();
        this.exportFile.exports().map(FsExport::getPath).forEach(path -> {
            Splitter splitter = Splitter.on((char)'/').omitEmptyStrings();
            Inode inode = root;
            for (String s : splitter.split((CharSequence)path)) {
                try {
                    inode = ExportPathCreator.tryToCreateIfMissing(this.vfs, inode, s);
                }
                catch (IOException e) {
                    return;
                }
            }
        });
    }

    private static void registerSignalHandler(ExportFile exports) {
        Signal.handle(new Signal("HUP"), signal -> {
            try {
                LOGGER.info("HUP signal received, rescanning exports file.");
                exports.rescan();
            }
            catch (IOException e) {
                LOGGER.error("Failed to re-read export file: {}", (Object)e.getMessage());
            }
        });
    }
}

