/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.chimera;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.dcache.acl.ACE;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.Who;
import org.dcache.auth.Subjects;
import org.dcache.chimera.DirNotEmptyHimeraFsException;
import org.dcache.chimera.DirectoryStreamHelper;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.FsInode_CONST;
import org.dcache.chimera.FsInode_ID;
import org.dcache.chimera.FsInode_NAMEOF;
import org.dcache.chimera.FsInode_PARENT;
import org.dcache.chimera.FsInode_PATHOF;
import org.dcache.chimera.FsInode_PCRC;
import org.dcache.chimera.FsInode_PCUR;
import org.dcache.chimera.FsInode_PLOC;
import org.dcache.chimera.FsInode_PSET;
import org.dcache.chimera.FsInode_TAG;
import org.dcache.chimera.FsInode_TAGS;
import org.dcache.chimera.InvalidArgumentChimeraException;
import org.dcache.chimera.IsDirChimeraException;
import org.dcache.chimera.JdbcFs;
import org.dcache.chimera.NotDirChimeraException;
import org.dcache.chimera.StorageLocatable;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadHandleException;
import org.dcache.nfs.status.BadOwnerException;
import org.dcache.nfs.status.ExistException;
import org.dcache.nfs.status.InvalException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.LayoutUnavailableException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.NotEmptyException;
import org.dcache.nfs.status.StaleException;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.acl.Acls;
import org.dcache.nfs.v4.xdr.aceflag4;
import org.dcache.nfs.v4.xdr.acemask4;
import org.dcache.nfs.v4.xdr.acetype4;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.utf8str_mixed;
import org.dcache.nfs.v4.xdr.verifier4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChimeraVfs
implements VirtualFileSystem,
AclCheckable {
    private static final int MIN_HANDLE_LEN = 4;
    private static final Logger _log = LoggerFactory.getLogger(ChimeraVfs.class);
    private final JdbcFs _fs;
    private final NfsIdMapping _idMapping;

    public ChimeraVfs(JdbcFs fs, NfsIdMapping idMapping) {
        this._fs = fs;
        this._idMapping = idMapping;
    }

    public Inode getRootInode() throws IOException {
        return this.toInode(FsInode.getRoot((FileSystemProvider)this._fs));
    }

    public Inode lookup(Inode parent, String path) throws IOException {
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = parentFsInode.inodeOf(path, FileSystemProvider.StatCacheOption.NO_STAT);
            return this.toInode(fsInode);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("Path Do not exist.");
        }
    }

    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        int uid = (int)Subjects.getUid((Subject)subject);
        int gid = (int)Subjects.getPrimaryGid((Subject)subject);
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = this._fs.createFile(parentFsInode, path, uid, gid, mode | this.typeToChimera(type), this.typeToChimera(type));
            return this.toInode(fsInode);
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        int uid = (int)Subjects.getUid((Subject)subject);
        int gid = (int)Subjects.getPrimaryGid((Subject)subject);
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = parentFsInode.mkdir(path, uid, gid, mode);
            return this.toInode(fsInode);
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        FsInode linkInode = this.toFsInode(link);
        try {
            FsInode fsInode = this._fs.createHLink(parentFsInode, linkInode, path);
            return this.toInode(fsInode);
        }
        catch (NotDirChimeraException e) {
            throw new NotDirException("parent not a directory");
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
        int uid = (int)Subjects.getUid((Subject)subject);
        int gid = (int)Subjects.getPrimaryGid((Subject)subject);
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = this._fs.createLink(parentFsInode, path, uid, gid, mode, link.getBytes(StandardCharsets.UTF_8));
            return this.toInode(fsInode);
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("path already exists");
        }
    }

    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return fsInode.read(offset, data, 0, count);
    }

    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        FsInode from = this.toFsInode(src);
        FsInode to = this.toFsInode(dest);
        try {
            return this._fs.rename(this._fs.inodeOf(from, oldName, FileSystemProvider.StatCacheOption.NO_STAT), from, oldName, to, newName);
        }
        catch (NotDirChimeraException e) {
            throw new NotDirException("not a directory");
        }
        catch (FileExistsChimeraFsException e) {
            throw new ExistException("destination exists");
        }
        catch (DirNotEmptyHimeraFsException e) {
            throw new NotEmptyException("directory exist and not empty");
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("file not found");
        }
    }

    public String readlink(Inode inode) throws IOException {
        int count;
        byte[] data;
        FsInode fsInode = this.toFsInode(inode);
        int n = this._fs.read(fsInode, 0L, data = new byte[count = (int)fsInode.statCache().getSize()], 0, count);
        if (n < 0) {
            throw new NfsIoException("Can't read symlink");
        }
        return new String(data, 0, n, StandardCharsets.UTF_8);
    }

    public void remove(Inode parent, String path) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        try {
            this._fs.remove(parentFsInode, path, this._fs.inodeOf(parentFsInode, path, FileSystemProvider.StatCacheOption.STAT));
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("path not found");
        }
        catch (DirNotEmptyHimeraFsException e) {
            throw new NotEmptyException("directory not empty");
        }
    }

    public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        int bytesWritten = fsInode.write(offset, data, 0, count);
        return new VirtualFileSystem.WriteResult(VirtualFileSystem.StabilityLevel.FILE_SYNC, bytesWritten);
    }

    public void commit(Inode inode, long offset, int count) throws IOException {
    }

    public DirectoryStream list(Inode inode, byte[] verifier, long cookie) throws IOException {
        FsInode parentFsInode = this.toFsInode(inode);
        byte[] currentVerifier = this.directoryVerifier(inode);
        List list = Lists.transform((List)DirectoryStreamHelper.listOf((FsInode)parentFsInode), e -> new DirectoryEntry(e.getName(), this.toInode(e.getInode()), ChimeraVfs.fromChimeraStat(e.getStat(), e.getInode().ino()), this.directoryCookieOf(e.getStat(), e.getName())));
        return new DirectoryStream(currentVerifier, (Collection)list);
    }

    public byte[] directoryVerifier(Inode inode) throws IOException {
        FsInode parentFsInode = this.toFsInode(inode);
        return verifier4.valueOf((long)parentFsInode.stat().getGeneration()).value;
    }

    public Inode parentOf(Inode inode) throws IOException {
        FsInode parent = this.toFsInode(inode).getParent();
        if (parent == null) {
            throw new NoEntException("no parent");
        }
        return this.toInode(parent);
    }

    public FsStat getFsStat() throws IOException {
        org.dcache.chimera.FsStat fsStat = this._fs.getFsStat();
        return new FsStat(fsStat.getTotalSpace(), fsStat.getTotalFiles(), fsStat.getUsedSpace(), fsStat.getUsedFiles());
    }

    private FsInode toFsInode(Inode inode) throws IOException {
        return this.inodeFromBytes(inode.getFileId());
    }

    private Inode toInode(FsInode inode) {
        return Inode.forFile((byte[])this.inodeToBytes(inode));
    }

    public Stat getattr(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        try {
            return ChimeraVfs.fromChimeraStat(fsInode.stat(), fsInode.ino());
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new NoEntException("Path Do not exist.");
        }
    }

    public void setattr(Inode inode, Stat stat) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        try {
            fsInode.setStat(ChimeraVfs.toChimeraStat(stat));
        }
        catch (InvalidArgumentChimeraException e) {
            throw new InvalException(e.getMessage());
        }
        catch (IsDirChimeraException e) {
            throw new IsDirException(e.getMessage());
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new StaleException(e.getMessage());
        }
    }

    public nfsace4[] getAcl(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        try {
            List dacl = this._fs.getACL(fsInode);
            org.dcache.chimera.posix.Stat stat = fsInode.statCache();
            nfsace4[] unixAcl = Acls.of((int)stat.getMode(), (boolean)fsInode.isDirectory());
            nfsace4[] aces = new nfsace4[dacl.size() + unixAcl.length];
            int i = 0;
            for (ACE ace : dacl) {
                aces[i] = ChimeraVfs.valueOf(ace, this._idMapping);
                ++i;
            }
            System.arraycopy(unixAcl, 0, aces, i, unixAcl.length);
            return Acls.compact((nfsace4[])aces);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new StaleException(e.getMessage());
        }
    }

    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        ArrayList<ACE> dacl = new ArrayList<ACE>();
        for (nfsace4 ace : acl) {
            dacl.add(ChimeraVfs.valueOf(ace, this._idMapping));
        }
        try {
            this._fs.setACL(fsInode, dacl);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new StaleException(e.getMessage());
        }
    }

    private static Stat fromChimeraStat(org.dcache.chimera.posix.Stat pStat, long fileid) {
        Stat stat = new Stat();
        stat.setATime(pStat.getATime());
        stat.setCTime(pStat.getCTime());
        stat.setMTime(pStat.getMTime());
        stat.setGid(pStat.getGid());
        stat.setUid(pStat.getUid());
        stat.setDev(pStat.getDev());
        stat.setIno(Longs.hashCode((long)pStat.getIno()));
        stat.setMode(pStat.getMode());
        stat.setNlink(pStat.getNlink());
        stat.setRdev(pStat.getRdev());
        stat.setSize(pStat.getSize());
        stat.setFileid(fileid);
        stat.setGeneration(pStat.getGeneration());
        return stat;
    }

    private static org.dcache.chimera.posix.Stat toChimeraStat(Stat stat) {
        org.dcache.chimera.posix.Stat pStat = new org.dcache.chimera.posix.Stat();
        if (stat.isDefined(Stat.StatAttribute.ATIME)) {
            pStat.setATime(stat.getATime());
        }
        if (stat.isDefined(Stat.StatAttribute.CTIME)) {
            pStat.setCTime(stat.getCTime());
        }
        if (stat.isDefined(Stat.StatAttribute.MTIME)) {
            pStat.setMTime(stat.getMTime());
        }
        if (stat.isDefined(Stat.StatAttribute.GROUP)) {
            pStat.setGid(stat.getGid());
        }
        if (stat.isDefined(Stat.StatAttribute.OWNER)) {
            pStat.setUid(stat.getUid());
        }
        if (stat.isDefined(Stat.StatAttribute.DEV)) {
            pStat.setDev(stat.getDev());
        }
        if (stat.isDefined(Stat.StatAttribute.MODE)) {
            pStat.setMode(stat.getMode());
        }
        if (stat.isDefined(Stat.StatAttribute.NLINK)) {
            pStat.setNlink(stat.getNlink());
        }
        if (stat.isDefined(Stat.StatAttribute.RDEV)) {
            pStat.setRdev(stat.getRdev());
        }
        if (stat.isDefined(Stat.StatAttribute.SIZE)) {
            pStat.setSize(stat.getSize());
        }
        if (stat.isDefined(Stat.StatAttribute.GENERATION)) {
            pStat.setGeneration(stat.getGeneration());
        }
        return pStat;
    }

    public int access(Inode inode, int mode) throws IOException {
        int accessmask = mode;
        return accessmask;
    }

    public boolean hasIOLayout(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return fsInode.type() == FsInodeType.INODE && fsInode.getLevel() == 0;
    }

    public AclCheckable getAclCheckable() {
        return this;
    }

    public NfsIdMapping getIdMapper() {
        return this._idMapping;
    }

    private int typeToChimera(Stat.Type type) {
        switch (type) {
            case SYMLINK: {
                return 40960;
            }
            case DIRECTORY: {
                return 16384;
            }
            case SOCK: {
                return 49152;
            }
            case FIFO: {
                return 4096;
            }
            case BLOCK: {
                return 24576;
            }
            case CHAR: {
                return 8192;
            }
        }
        return 32768;
    }

    private static nfsace4 valueOf(ACE ace, NfsIdMapping idMapping) {
        String principal;
        switch (ace.getWho()) {
            case USER: {
                principal = idMapping.uidToPrincipal(ace.getWhoID());
                break;
            }
            case GROUP: {
                principal = idMapping.gidToPrincipal(ace.getWhoID());
                break;
            }
            default: {
                principal = ace.getWho().getAbbreviation();
            }
        }
        nfsace4 nfsace = new nfsace4();
        nfsace.access_mask = new acemask4(new uint32_t(ace.getAccessMsk()));
        nfsace.flag = new aceflag4(new uint32_t(ace.getFlags()));
        nfsace.type = new acetype4(new uint32_t(ace.getType().getValue()));
        nfsace.who = new utf8str_mixed(principal);
        return nfsace;
    }

    private static ACE valueOf(nfsace4 ace, NfsIdMapping idMapping) throws BadOwnerException {
        String principal = ace.who.toString();
        int type = ace.type.value.value;
        int flags = ace.flag.value.value;
        int mask = ace.access_mask.value.value;
        int id = -1;
        Who who = Who.fromAbbreviation((String)principal);
        if (who == null) {
            boolean isGroup = AceFlags.IDENTIFIER_GROUP.matches(flags);
            if (isGroup) {
                who = Who.GROUP;
                id = idMapping.principalToGid(principal);
            } else {
                who = Who.USER;
                id = idMapping.principalToUid(principal);
            }
        }
        return new ACE(AceType.valueOf((int)type), flags, mask, who, id);
    }

    public AclCheckable.Access checkAcl(Subject subject, Inode inode, int access) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        List acl = this._fs.getACL(fsInode);
        org.dcache.chimera.posix.Stat stat = this._fs.stat(fsInode);
        return this.checkAcl(subject, acl, stat.getUid(), stat.getGid(), access);
    }

    private AclCheckable.Access checkAcl(Subject subject, List<ACE> acl, int owner, int group, int access) {
        for (ACE ace : acl) {
            Who who;
            int ace_mask;
            int flag = ace.getFlags();
            if ((flag & 8) != 0 || ace.getType() != AceType.ACCESS_ALLOWED_ACE_TYPE && ace.getType() != AceType.ACCESS_DENIED_ACE_TYPE || ((ace_mask = ace.getAccessMsk()) & access) == 0 || !((who = ace.getWho()) == Who.EVERYONE || who == Who.OWNER && Subjects.hasUid((Subject)subject, (long)owner) || who == Who.OWNER_GROUP && Subjects.hasGid((Subject)subject, (long)group) || who == Who.GROUP && Subjects.hasGid((Subject)subject, (long)ace.getWhoID())) && (who != Who.USER || !Subjects.hasUid((Subject)subject, (long)ace.getWhoID()))) continue;
            if (ace.getType() == AceType.ACCESS_DENIED_ACE_TYPE) {
                return AclCheckable.Access.DENY;
            }
            return AclCheckable.Access.ALLOW;
        }
        return AclCheckable.Access.UNDEFINED;
    }

    private byte[] inodeToBytes(FsInode inode) {
        return inode.getIdentifier();
    }

    public FsInode inodeFromBytes(byte[] handle) throws BadHandleException {
        FsInode_ID inode;
        if (handle.length < 4) {
            throw new BadHandleException("Bad file handle");
        }
        ByteBuffer b = ByteBuffer.wrap(handle);
        byte fsid = b.get();
        byte type = b.get();
        byte len = b.get();
        long ino = b.getLong();
        byte opaqueLen = b.get();
        if (opaqueLen > b.remaining()) {
            throw new BadHandleException("Bad/old file handle");
        }
        FsInodeType inodeType = FsInodeType.valueOf((int)type);
        switch (inodeType) {
            case INODE: {
                if (opaqueLen != 1) {
                    throw new BadHandleException("Bad file handle: invalid level len :" + opaqueLen);
                }
                int level = b.get() - 48;
                if (level < 0 || level > 7) {
                    throw new BadHandleException("Bad file handle: invalid level:" + level);
                }
                inode = new FsInode((FileSystemProvider)this._fs, ino, level);
                break;
            }
            case ID: {
                inode = new FsInode_ID((FileSystemProvider)this._fs, ino);
                break;
            }
            case TAGS: {
                inode = new FsInode_TAGS((FileSystemProvider)this._fs, ino);
                break;
            }
            case TAG: {
                String tag = new String(handle, b.position(), (int)opaqueLen);
                inode = new FsInode_TAG((FileSystemProvider)this._fs, ino, tag);
                break;
            }
            case NAMEOF: {
                inode = new FsInode_NAMEOF((FileSystemProvider)this._fs, ino);
                break;
            }
            case PARENT: {
                inode = new FsInode_PARENT((FileSystemProvider)this._fs, ino);
                break;
            }
            case PATHOF: {
                inode = new FsInode_PATHOF((FileSystemProvider)this._fs, ino);
                break;
            }
            case CONST: {
                inode = new FsInode_CONST((FileSystemProvider)this._fs, ino);
                break;
            }
            case PSET: {
                inode = new FsInode_PSET((FileSystemProvider)this._fs, ino, this.getArgs(b, opaqueLen));
                break;
            }
            case PCUR: {
                inode = new FsInode_PCUR((FileSystemProvider)this._fs, ino);
                break;
            }
            case PLOC: {
                inode = new FsInode_PLOC((FileSystemProvider)this._fs, ino);
                break;
            }
            case PCRC: {
                inode = new FsInode_PCRC((FileSystemProvider)this._fs, ino);
                break;
            }
            default: {
                throw new BadHandleException("Unsupported file handle type: " + inodeType);
            }
        }
        return inode;
    }

    private String[] getArgs(ByteBuffer b, int opaqueLen) {
        StringTokenizer st = new StringTokenizer(new String(b.array(), b.position(), opaqueLen), "[:]");
        int argc = st.countTokens();
        String[] args = new String[argc];
        for (int i = 0; i < argc; ++i) {
            args[i] = st.nextToken();
        }
        return args;
    }

    private long directoryCookieOf(org.dcache.chimera.posix.Stat stat, String name) {
        return (stat.getIno() << 32 | (long)name.hashCode()) & Long.MAX_VALUE;
    }

    public String getInodeLayout(Inode inode) throws ChimeraNFSException, IOException {
        FsInode fsInode = this.toFsInode(inode);
        if (fsInode.type() != FsInodeType.INODE || fsInode.getLevel() != 0) {
            throw new LayoutUnavailableException();
        }
        return this._fs.getInodeLocations(fsInode, 1).stream().map(StorageLocatable::location).findFirst().orElse(null);
    }

    public boolean setInodeLayout(Inode inode, String layout) throws IOException {
        return this._fs.setInodeLocation(this.toFsInode(inode), 1, layout);
    }

    public byte[] getXattr(Inode inode, String attr) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return this._fs.getXattr(fsInode, attr);
    }

    public void setXattr(Inode inode, String attr, byte[] value, VirtualFileSystem.SetXattrMode mode) throws IOException {
        FileSystemProvider.SetXattrMode m;
        FsInode fsInode = this.toFsInode(inode);
        switch (mode) {
            case CREATE: {
                m = FileSystemProvider.SetXattrMode.CREATE;
                break;
            }
            case REPLACE: {
                m = FileSystemProvider.SetXattrMode.REPLACE;
                break;
            }
            case EITHER: {
                m = FileSystemProvider.SetXattrMode.EITHER;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this._fs.setXattr(fsInode, attr, value, m);
    }

    public String[] listXattrs(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return (String[])this._fs.listXattrs(fsInode).stream().toArray(String[]::new);
    }

    public void removeXattr(Inode inode, String attr) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        this._fs.removeXattr(fsInode, attr);
    }
}

