/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.rados4j;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import jnr.constants.platform.Errno;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.byref.LongLongByReference;
import jnr.ffi.byref.PointerByReference;
import jnr.ffi.provider.FFIProvider;
import org.dcache.rados4j.Error;
import org.dcache.rados4j.RadosException;
import org.dcache.rados4j.RbdImage;
import org.dcache.rados4j.RbdImageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rbd {
    private final Logger LOG = LoggerFactory.getLogger(Rbd.class);
    private final LibRbd libRbd;
    private final Runtime runtime;
    private final Pointer ctx;

    Rbd(Pointer ctx) throws RadosException {
        this.ctx = ctx;
        this.libRbd = (LibRbd)FFIProvider.getSystemProvider().createLibraryLoader(LibRbd.class).load("rbd");
        this.runtime = Runtime.getRuntime((Object)this.libRbd);
        this.LOG.info("Using RBD version {}", (Object)this.version());
    }

    public String version() throws RadosException {
        IntByReference maj = new IntByReference();
        IntByReference min = new IntByReference();
        IntByReference extra = new IntByReference();
        int rc = this.libRbd.rbd_version(maj, min, extra);
        Error.checkError(this.runtime, rc, "Failed to get version number");
        return maj.intValue() + "." + min.intValue() + "." + extra.intValue();
    }

    public void create(String name, long size) throws RadosException {
        IntByReference order = new IntByReference(0);
        int rc = this.libRbd.rbd_create(this.ctx, name, size, order);
        Error.checkError(this.runtime, rc, "Failed to create image " + name);
    }

    public RbdImage open(String name) throws RadosException {
        PointerByReference imagePtr = new PointerByReference();
        int rc = this.libRbd.rbd_open(this.ctx, name, imagePtr, null);
        Error.checkError(this.runtime, rc, "Failed to open image " + name);
        return new RbdImage((Pointer)imagePtr.getValue(), name, this.libRbd, this.runtime);
    }

    public RbdImage openReadOnly(String name) throws RadosException {
        PointerByReference imagePtr = new PointerByReference();
        int rc = this.libRbd.rbd_open_read_only(this.ctx, name, imagePtr, null);
        Error.checkError(this.runtime, rc, "Failed to (ro)open image " + name);
        return new RbdImage((Pointer)imagePtr.getValue(), name, this.libRbd, this.runtime);
    }

    public void remove(String name) throws RadosException {
        int rc = this.libRbd.rbd_remove(this.ctx, name);
        Error.checkError(this.runtime, rc, "Failed to remove image " + name);
    }

    public Set<String> list() throws RadosException {
        byte[] names;
        int rc;
        LongLongByReference size = new LongLongByReference(1024L);
        while ((rc = this.libRbd.rbd_list(this.ctx, names = new byte[size.intValue()], size)) == -Errno.ERANGE.intValue()) {
            this.LOG.debug("Bigger array required to get the listing: {}", (Object)size.intValue());
        }
        if (rc < 0) {
            Error.checkError(this.runtime, rc, "Failed to get list of RBD images");
            throw new RuntimeException("must never get here");
        }
        HashSet<String> dirList = new HashSet<String>();
        int o = 0;
        for (int i = 0; i < rc; ++i) {
            if (names[i] != 0) continue;
            dirList.add(new String(names, o, i - o, StandardCharsets.UTF_8));
            o = i + 1;
        }
        return dirList;
    }

    public static interface LibRbd {
        public int rbd_version(@Out IntByReference var1, @Out IntByReference var2, @Out IntByReference var3);

        public int rbd_create(@In Pointer var1, @In String var2, @In long var3, @In @Out IntByReference var5);

        public int rbd_open(@In Pointer var1, @In String var2, @Out PointerByReference var3, @In String var4);

        public int rbd_open_read_only(@In Pointer var1, @In String var2, @Out PointerByReference var3, @In String var4);

        public int rbd_close(@In Pointer var1);

        public int rbd_remove(@In Pointer var1, @In String var2);

        public int rbd_write(@In Pointer var1, long var2, int var4, @In ByteBuffer var5);

        public int rbd_read(@In Pointer var1, long var2, int var4, @Out ByteBuffer var5);

        public int rbd_stat(@In Pointer var1, @Out RbdImageInfo var2, long var3);

        public int rbd_resize(@In Pointer var1, long var2);

        public int rbd_list(@In Pointer var1, @In @Out byte[] var2, @In @Out LongLongByReference var3);
    }
}

