/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.rados4j;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.dcache.rados4j.Error;
import org.dcache.rados4j.Rados;
import org.dcache.rados4j.RadosException;
import org.dcache.rados4j.Rbd;

public class IoCtx {
    private final Pointer ctx;
    private final Rados.LibRados rados;
    private final Runtime runtime;

    public IoCtx(Pointer ctx, Rados.LibRados rados, Runtime runtime) {
        this.ctx = ctx;
        this.rados = rados;
        this.runtime = runtime;
    }

    public void destroy() throws RadosException {
        int rc = this.rados.rados_ioctx_destroy(this.ctx);
        Error.checkError(this.runtime, rc, "Failed to destroy io context");
    }

    public Rbd createRbd() throws RadosException {
        return new Rbd(this.ctx);
    }

    Pointer pointer() {
        return this.ctx;
    }
}

