/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.rados4j;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.byref.PointerByReference;
import jnr.ffi.provider.FFIProvider;
import org.dcache.rados4j.Error;
import org.dcache.rados4j.IoCtx;
import org.dcache.rados4j.RadosClusterInfo;
import org.dcache.rados4j.RadosException;
import org.dcache.rados4j.RadosPoolInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rados {
    private final Logger LOG = LoggerFactory.getLogger(Rados.class);
    private final LibRados libRados = (LibRados)FFIProvider.getSystemProvider().createLibraryLoader(LibRados.class).load("rados");
    private final Runtime runtime = Runtime.getRuntime((Object)this.libRados);
    private final Pointer cluster;

    public Rados(String id, String configFile) throws RadosException {
        PointerByReference clusterPtr = new PointerByReference();
        int rc = this.libRados.rados_create(clusterPtr, id);
        Error.checkError(this.runtime, rc, "Failed to create cluster");
        this.cluster = (Pointer)clusterPtr.getValue();
        rc = this.libRados.rados_conf_read_file(this.cluster, configFile);
        Error.checkError(this.runtime, rc, "Failed to read config file");
        this.LOG.info("Using RADOS version {}", (Object)this.version());
    }

    public String version() throws RadosException {
        IntByReference maj = new IntByReference();
        IntByReference min = new IntByReference();
        IntByReference extra = new IntByReference();
        int rc = this.libRados.rados_version(maj, min, extra);
        Error.checkError(this.runtime, rc, "Failed to get version number");
        return maj.intValue() + "." + min.intValue() + "." + extra.intValue();
    }

    public void connect() throws RadosException {
        int rc = this.libRados.rados_connect(this.cluster);
        Error.checkError(this.runtime, rc, "Failed to connect to cluster");
    }

    public void shutdown() throws RadosException {
        int rc = this.libRados.rados_shutdown(this.cluster);
        Error.checkError(this.runtime, rc, "Failed to shutdown rados");
    }

    public void createPool(String poolName) throws RadosException {
        int rc = this.libRados.rados_pool_create(this.cluster, poolName);
        Error.checkError(this.runtime, rc, "Failed to create pool " + poolName);
    }

    public void deletePool(String poolName) throws RadosException {
        int rc = this.libRados.rados_pool_delete(this.cluster, poolName);
        Error.checkError(this.runtime, rc, "Failed to delete pool " + poolName);
    }

    public IoCtx createIoContext(String poolName) throws RadosException {
        PointerByReference ctxPtr = new PointerByReference();
        int rc = this.libRados.rados_ioctx_create(this.cluster, poolName, ctxPtr);
        Error.checkError(this.runtime, rc, "Failed to create IO context for pool " + poolName);
        return new IoCtx((Pointer)ctxPtr.getValue(), this.libRados, this.runtime);
    }

    public RadosPoolInfo statPool(IoCtx ctx) throws RadosException {
        RadosPoolInfo poolInfo = new RadosPoolInfo(this.runtime);
        int rc = this.libRados.rados_ioctx_pool_stat(ctx.pointer(), poolInfo);
        Error.checkError(this.runtime, rc, "Failed to get pool status");
        return poolInfo;
    }

    public RadosClusterInfo statCluster() throws RadosException {
        RadosClusterInfo clusterInfo = new RadosClusterInfo(this.runtime);
        int rc = this.libRados.rados_cluster_stat(this.cluster, clusterInfo);
        Error.checkError(this.runtime, rc, "Failed to get cluster status");
        return clusterInfo;
    }

    public void setXattr(String obj, String name, byte[] data) throws RadosException {
        int rc = this.libRados.rados_setxattr(this.cluster, obj, name, data, data.length);
        Error.checkError(this.runtime, rc, "Failed to set xattr " + name);
    }

    public int getXattr(String obj, String name, byte[] data) throws RadosException {
        int rc = this.libRados.rados_getxattr(this.cluster, obj, name, data, data.length);
        Error.checkError(this.runtime, rc, "Failed to get xattr " + name);
        return rc;
    }

    public void rmXattr(String obj, String name) throws RadosException {
        int rc = this.libRados.rados_rmxattr(this.cluster, obj, name);
        Error.checkError(this.runtime, rc, "Failed to remove xattr " + name);
    }

    public static interface LibRados {
        public int rados_version(@Out IntByReference var1, @Out IntByReference var2, @Out IntByReference var3);

        public int rados_create(@Out PointerByReference var1, @In String var2);

        public int rados_conf_read_file(@In Pointer var1, @In String var2);

        public int rados_connect(@In Pointer var1);

        public int rados_shutdown(@In Pointer var1);

        public int rados_cluster_stat(@In Pointer var1, @Out RadosClusterInfo var2);

        public int rados_pool_create(@In Pointer var1, @In String var2);

        public int rados_pool_delete(@In Pointer var1, @In String var2);

        public int rados_ioctx_pool_stat(@In Pointer var1, @Out RadosPoolInfo var2);

        public int rados_ioctx_create(@In Pointer var1, @In String var2, @Out PointerByReference var3);

        public int rados_ioctx_destroy(@In Pointer var1);

        public int rados_getxattr(@In Pointer var1, @In String var2, @In String var3, @Out byte[] var4, long var5);

        public int rados_setxattr(@In Pointer var1, @In String var2, @In String var3, @In byte[] var4, long var5);

        public int rados_rmxattr(@In Pointer var1, @In String var2, @In String var3);
    }
}

