/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.rados4j;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.dcache.rados4j.Error;
import org.dcache.rados4j.Rados;
import org.dcache.rados4j.RadosException;
import org.dcache.rados4j.Rbd;

public class IoCtx {
    private final Pointer ctx;
    private final Rados.LibRados rados;
    private final Runtime runtime;

    public IoCtx(Pointer ctx, Rados.LibRados rados, Runtime runtime) {
        this.ctx = ctx;
        this.rados = rados;
        this.runtime = runtime;
    }

    public void destroy() throws RadosException {
        int rc = this.rados.rados_ioctx_destroy(this.ctx);
        Error.checkError(this.runtime, rc, "Failed to destroy io context");
    }

    public Rbd createRbd() throws RadosException {
        return new Rbd(this.ctx);
    }

    Pointer pointer() {
        return this.ctx;
    }

    public void setXattr(String obj, String name, byte[] data) throws RadosException {
        int rc = this.rados.rados_setxattr(this.ctx, obj, name, data, data.length);
        Error.checkError(this.runtime, rc, "Failed to set xattr " + name);
    }

    public int getXattr(String obj, String name, byte[] data) throws RadosException {
        int rc = this.rados.rados_getxattr(this.ctx, obj, name, data, data.length);
        Error.checkError(this.runtime, rc, "Failed to get xattr " + name);
        return rc;
    }

    public void rmXattr(String obj, String name) throws RadosException {
        int rc = this.rados.rados_rmxattr(this.ctx, obj, name);
        Error.checkError(this.runtime, rc, "Failed to remove xattr " + name);
    }
}

