/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.rados4j;

import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.dcache.rados4j.Error;
import org.dcache.rados4j.RadosException;
import org.dcache.rados4j.Rbd;
import org.dcache.rados4j.RbdImageInfo;

public class RbdImage
implements AutoCloseable {
    private final Pointer image;
    private final Rbd.LibRbd rbd;
    private final Runtime runtime;
    private final String name;

    public RbdImage(Pointer image, String name, Rbd.LibRbd rbd, Runtime runtime) {
        this.image = image;
        this.rbd = rbd;
        this.runtime = runtime;
        this.name = name;
    }

    @Override
    public void close() throws RadosException {
        int rc = this.rbd.rbd_close(this.image);
        Error.checkError(this.runtime, rc, "Failed to close image " + this.name);
    }

    public int write(byte[] data, long offset, int length) throws RadosException {
        return this.write(ByteBuffer.wrap(data), offset);
    }

    public int read(byte[] data, long offset, int length) throws RadosException {
        return this.read(ByteBuffer.wrap(data), offset);
    }

    public int write(ByteBuffer buf, long offset) throws RadosException {
        int rc = this.rbd.rbd_write(this.image, offset, buf.remaining(), buf);
        Error.checkError(this.runtime, rc, "Failed to write into image " + this.name);
        buf.position(buf.position() + rc);
        return rc;
    }

    public int read(ByteBuffer buf, long offset) throws RadosException {
        int rc = this.rbd.rbd_read(this.image, offset, buf.remaining(), buf);
        Error.checkError(this.runtime, rc, "Failed to read from image " + this.name);
        buf.position(buf.position() + rc);
        return rc;
    }

    public void resize(long newSize) throws RadosException {
        int rc = this.rbd.rbd_resize(this.image, newSize);
        Error.checkError(this.runtime, rc, "Failed to resize image " + this.name);
    }

    public RbdImageInfo stat() throws RadosException {
        RbdImageInfo info = new RbdImageInfo(this.runtime);
        int rc = this.rbd.rbd_stat(this.image, info, 0L);
        Error.checkError(this.runtime, rc, "Failed to stat imoge " + this.name);
        return info;
    }
}

