/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.rquota;

import javax.security.auth.Subject;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.util.SubjectHolder;
import org.dcache.nfs.util.UnixSubjects;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.rquota.QuotaVfs;
import org.dcache.rquota.xdr.ext_getquota_args;
import org.dcache.rquota.xdr.ext_setquota_args;
import org.dcache.rquota.xdr.getquota_args;
import org.dcache.rquota.xdr.getquota_rslt;
import org.dcache.rquota.xdr.rquotaServerStub;
import org.dcache.rquota.xdr.setquota_args;
import org.dcache.rquota.xdr.setquota_rslt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaSvc
extends rquotaServerStub {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuotaSvc.class);
    private final QuotaVfs qfs;
    private final ExportTable exportTable;

    public QuotaSvc(QuotaVfs qfs, ExportTable exportTable) {
        this.qfs = qfs;
        this.exportTable = exportTable;
    }

    @Override
    public getquota_rslt RQUOTAPROC_GETQUOTA_1(RpcCall call$, getquota_args arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public getquota_rslt RQUOTAPROC_GETACTIVEQUOTA_1(RpcCall call$, getquota_args arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public setquota_rslt RQUOTAPROC_SETQUOTA_1(RpcCall call$, setquota_args arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public setquota_rslt RQUOTAPROC_SETACTIVEQUOTA_1(RpcCall call$, setquota_args arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public getquota_rslt RQUOTAPROC_GETQUOTA_2(RpcCall call$, ext_getquota_args arg1) {
        getquota_rslt r = new getquota_rslt();
        if (!this.canQuery(call$.getCredential().getSubject(), arg1.gqa_id, arg1.gqa_type)) {
            r.status = 3;
            return r;
        }
        r.status = 1;
        r.gqr_rquota = this.qfs.getQuota(arg1.gqa_id, arg1.gqa_type);
        return r;
    }

    @Override
    public getquota_rslt RQUOTAPROC_GETACTIVEQUOTA_2(RpcCall call$, ext_getquota_args arg1) {
        getquota_rslt r = new getquota_rslt();
        if (!this.canQuery(call$.getCredential().getSubject(), arg1.gqa_id, arg1.gqa_type)) {
            r.status = 3;
            return r;
        }
        r.status = 1;
        r.gqr_rquota = this.qfs.getQuota(arg1.gqa_id, arg1.gqa_type);
        return r;
    }

    @Override
    public setquota_rslt RQUOTAPROC_SETQUOTA_2(RpcCall call$, ext_setquota_args arg1) {
        setquota_rslt result = new setquota_rslt();
        String path = "/" + arg1.sqa_pathp;
        FsExport export = this.exportTable.getExport(path, call$.getTransport().getRemoteSocketAddress().getAddress());
        if (export == null) {
            result.status = 3;
            return result;
        }
        if (!UnixSubjects.isRootSubject((Subject)call$.getCredential().getSubject()) || !export.isTrusted()) {
            result.status = 3;
            return result;
        }
        result.sqr_rquota = this.qfs.setQuota(arg1.sqa_id, arg1.sqa_type, arg1.sqa_dqblk);
        result.status = 1;
        return result;
    }

    @Override
    public setquota_rslt RQUOTAPROC_SETACTIVEQUOTA_2(RpcCall call$, ext_setquota_args arg1) {
        setquota_rslt result = new setquota_rslt();
        String path = "/" + arg1.sqa_pathp;
        FsExport export = this.exportTable.getExport(path, call$.getTransport().getRemoteSocketAddress().getAddress());
        if (export == null) {
            result.status = 3;
            return result;
        }
        if (!UnixSubjects.isRootSubject((Subject)call$.getCredential().getSubject()) || !export.isTrusted()) {
            result.status = 3;
            return result;
        }
        result.sqr_rquota = this.qfs.setQuota(arg1.sqa_id, arg1.sqa_type, arg1.sqa_dqblk);
        result.status = 1;
        return result;
    }

    private boolean canQuery(Subject subject, int id, int type) {
        boolean canQuery = UnixSubjects.isRootSubject((Subject)subject) || type == 0 && UnixSubjects.hasUid((Subject)subject, (long)id) || type == 1 && UnixSubjects.hasGid((Subject)subject, (long)id);
        LOGGER.debug("Request by {} to query quota for id {} and type {}: {}", new Object[]{new SubjectHolder(subject), id, type, canQuery ? "granted" : "denied"});
        return canQuery;
    }
}

