/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.alice;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Stack;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dcache.xrootd.plugins.alice.Base64;
import org.dcache.xrootd.plugins.alice.CorruptedEnvelopeException;
import org.dcache.xrootd.plugins.alice.Envelope;

public class EncryptedAuthzToken {
    private static final String CYPHER_START = "-----BEGIN SEALED CIPHER-----";
    private static final String CYPHER_END = "-----END SEALED CIPHER-----";
    private static final String ENVELOPE_START = "-----BEGIN SEALED ENVELOPE-----";
    private static final String ENVELOPE_END = "-----END SEALED ENVELOPE-----";
    private static final byte[] BLOWFISH_IV = "$KJh#(}q".getBytes();
    private StringBuffer cipherEncryptedBase64;
    private StringBuffer envelopeEncryptedBase64;
    private byte[] symmetricKey;
    private byte[] signature;
    private byte[] envelope;
    private RSAPrivateKey privKey;
    private RSAPublicKey pubKey;

    public EncryptedAuthzToken(String rawToken, RSAPrivateKey privKey, RSAPublicKey pubKey) throws GeneralSecurityException {
        this.privKey = privKey;
        this.pubKey = pubKey;
        this.splitToken(rawToken);
    }

    public String decrypt() throws GeneralSecurityException {
        this.decryptSealedCipher();
        this.decryptSealedEnvelope();
        if (!this.verifyEnvelope()) {
            return null;
        }
        return new String(this.envelope);
    }

    private void decryptSealedCipher() throws GeneralSecurityException {
        byte[] encryptedCipher = Base64.decode(this.cipherEncryptedBase64.toString());
        Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
        cipher.init(4, this.privKey);
        this.symmetricKey = cipher.unwrap(encryptedCipher, "Blowfish", 3).getEncoded();
    }

    private void decryptSealedEnvelope() throws GeneralSecurityException {
        byte[] encryptedEnvelope = Base64.decode(this.envelopeEncryptedBase64.toString());
        int signatureLength = encryptedEnvelope[0] & 0xFF000000 | encryptedEnvelope[1] & 0xFF0000 | encryptedEnvelope[2] & 0xFF00 | encryptedEnvelope[3] & 0xFF;
        int envelopeOffset = 4 + signatureLength;
        this.signature = new byte[signatureLength];
        System.arraycopy(encryptedEnvelope, 4, this.signature, 0, signatureLength);
        int keylen = this.symmetricKey.length - 1;
        SecretKeySpec symKeySpec = new SecretKeySpec(this.symmetricKey, 0, keylen, "Blowfish");
        Cipher cipher = Cipher.getInstance("Blowfish/CBC/PKCS5Padding", "BC");
        cipher.init(2, (Key)symKeySpec, new IvParameterSpec(BLOWFISH_IV));
        this.envelope = cipher.doFinal(encryptedEnvelope, envelopeOffset, encryptedEnvelope.length - envelopeOffset);
    }

    private boolean verifyEnvelope() throws GeneralSecurityException {
        Signature signer = Signature.getInstance("SHA1withRSA", "BC");
        signer.initVerify(this.pubKey);
        signer.update(this.envelope);
        return signer.verify(this.signature);
    }

    private void splitToken(String rawToken) throws GeneralSecurityException {
        this.cipherEncryptedBase64 = new StringBuffer();
        this.envelopeEncryptedBase64 = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        LineNumberReader input = new LineNumberReader(new StringReader(rawToken));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                if (line.equals(CYPHER_START)) {
                    stack.push(CYPHER_START);
                    continue;
                }
                if (line.equals(CYPHER_END)) {
                    if (!stack.peek().equals(CYPHER_START)) {
                        throw new GeneralSecurityException("Illegal format: Cannot parse encrypted cipher");
                    }
                    stack.pop();
                    continue;
                }
                if (line.equals(ENVELOPE_START)) {
                    if (!stack.isEmpty()) {
                        throw new GeneralSecurityException("Illegal format: Cannot parse encrypted envelope");
                    }
                    stack.push(ENVELOPE_START);
                    continue;
                }
                if (line.equals(ENVELOPE_END)) {
                    if (!stack.peek().equals(ENVELOPE_START)) {
                        throw new GeneralSecurityException("Illegal format: Cannot parse encrypted envelope");
                    }
                    stack.pop();
                    continue;
                }
                if (stack.isEmpty()) continue;
                if (stack.peek().equals(CYPHER_START)) {
                    this.cipherEncryptedBase64.append(line);
                    continue;
                }
                if (!stack.peek().equals(ENVELOPE_START)) continue;
                this.envelopeEncryptedBase64.append(line);
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException("error reading from token string");
        }
        try {
            input.close();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("error closing stream where token string was parsed from");
        }
    }

    private String arrayToHex(String name, byte[] array, int offset, int len) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(name + ": ");
        for (int i = offset; i < offset + len; ++i) {
            String s = Integer.toHexString(array[i] & 0xFF);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s.toUpperCase());
        }
        sb.append(" (total:");
        sb.append(len);
        sb.append(" bytes)");
        return sb.toString();
    }

    public Envelope getEnvelope() throws CorruptedEnvelopeException, GeneralSecurityException {
        return new Envelope(new String(this.envelope));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

