/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.alice;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import org.dcache.xrootd.plugins.alice.CorruptedEnvelopeException;
import org.dcache.xrootd.protocol.XrootdProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Envelope {
    private String creator;
    private long created;
    private long expires;
    private boolean valid = false;
    private List<GridFile> files = new LinkedList<GridFile>();
    private static final String ENVELOPE_START = "-----BEGIN ENVELOPE-----";
    private static final String ENVELOPE_STOP = "-----END ENVELOPE-----";
    private static final String BODY_START = "-----BEGIN ENVELOPE BODY-----";
    private static final String BODY_STOP = "-----END ENVELOPE BODY-----";
    public static final Map<String, XrootdProtocol.FilePerm> filePermissions = new HashMap<String, XrootdProtocol.FilePerm>();
    private static final long TIME_OFFSET = 60L;
    Stack stack = new Stack();

    public Envelope(String envelope) throws CorruptedEnvelopeException, GeneralSecurityException {
        this.parse(envelope);
        this.checkValidity();
    }

    private void parse(String envelope) throws CorruptedEnvelopeException {
        LineNumberReader input = new LineNumberReader(new StringReader(envelope));
        try {
            String line;
            while ((line = input.readLine()) != null) {
                if (line.equals(ENVELOPE_START)) {
                    this.stack.push(ENVELOPE_START);
                    continue;
                }
                if (line.equals(ENVELOPE_STOP)) {
                    if (!this.stack.peek().equals(ENVELOPE_START)) {
                        throw new CorruptedEnvelopeException("Parse error near -----END ENVELOPE-----");
                    }
                    this.stack.pop();
                    continue;
                }
                if (line.equals(BODY_START)) {
                    this.stack.push(BODY_START);
                    continue;
                }
                if (line.equals(BODY_STOP)) {
                    if (!this.stack.peek().equals(BODY_START)) {
                        throw new CorruptedEnvelopeException("Parse error near -----END ENVELOPE BODY-----");
                    }
                    this.stack.pop();
                    continue;
                }
                if (this.stack.empty() || "".equals(line)) continue;
                if (this.stack.peek().equals(ENVELOPE_START)) {
                    this.parseHeader(line);
                    continue;
                }
                if (!this.stack.peek().equals(BODY_START)) continue;
                StringBuffer xmlBody = new StringBuffer(line);
                while (!line.equals("</authz>") && (line = input.readLine()) != null) {
                    xmlBody.append(line);
                }
                this.parseBody(xmlBody.toString());
            }
        }
        catch (IOException e) {
            throw new CorruptedEnvelopeException("Error reading from envelope String while parsing");
        }
        try {
            input.close();
        }
        catch (IOException e) {
            throw new CorruptedEnvelopeException("Error closing stream where envelope string was parsed from");
        }
    }

    private void parseHeader(String line) {
        String key;
        StringTokenizer tokenizer = new StringTokenizer(line, ": ");
        try {
            key = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            return;
        }
        if (key.equals("CREATOR")) {
            this.creator = tokenizer.nextToken();
            return;
        }
        if (key.equals("UNIXTIME")) {
            this.created = Long.parseLong(tokenizer.nextToken());
            return;
        }
        if (key.equals("EXPIRES")) {
            this.expires = Long.parseLong(tokenizer.nextToken());
            return;
        }
    }

    private void parseBody(String xmlBody) throws CorruptedEnvelopeException {
        String[] tags = new String[]{"authz", "file", "lfn", "turl", "access"};
        StringTokenizer tokenizer = new StringTokenizer(xmlBody, "<> ");
        String tmpLfn = null;
        String tmpTURL = null;
        String tmpPerm = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(tags[0])) {
                this.stack.push(tags[0]);
                continue;
            }
            if (this.stack.peek().equals(tags[0]) && token.equals("/" + tags[0])) {
                this.stack.pop();
                continue;
            }
            if (this.stack.peek().equals(tags[0]) && token.equals(tags[1])) {
                this.stack.push(tags[1]);
                tmpPerm = null;
                tmpTURL = null;
                tmpLfn = null;
                continue;
            }
            if (this.stack.peek().equals(tags[1]) && token.equals("/" + tags[1])) {
                this.stack.pop();
                this.files.add(new GridFile(tmpLfn, tmpTURL, tmpPerm));
                if (filePermissions.containsKey(tmpPerm)) continue;
                throw new CorruptedEnvelopeException("unknown access parameter for lfn " + tmpLfn + ": " + tmpPerm);
            }
            if (this.stack.peek().equals(tags[1]) && token.equals(tags[2])) {
                tmpLfn = tokenizer.nextToken();
                if (tokenizer.nextToken().equals("/" + tags[2])) continue;
                throw new CorruptedEnvelopeException("Parse error near: " + tmpLfn);
            }
            if (this.stack.peek().equals(tags[1]) && token.equals(tags[3])) {
                tmpTURL = tokenizer.nextToken();
                if (tokenizer.nextToken().equals("/" + tags[3])) continue;
                throw new CorruptedEnvelopeException("Parse error near: " + tmpTURL);
            }
            if (!this.stack.peek().equals(tags[1]) || !token.equals(tags[4])) continue;
            tmpPerm = tokenizer.nextToken();
            if (tokenizer.nextToken().equals("/" + tags[4])) continue;
            throw new CorruptedEnvelopeException("Parse error near: " + tmpPerm);
        }
    }

    private void checkValidity() throws GeneralSecurityException, CorruptedEnvelopeException {
        long current = System.currentTimeMillis() / 1000L;
        if (this.created - 60L > current) {
            throw new GeneralSecurityException("Envelope creation time lies in the future: " + new Date(this.created * 1000L));
        }
        if (this.expires != 0L && current > this.expires) {
            throw new GeneralSecurityException("Envelope expired " + new Date(this.expires * 1000L));
        }
        if (this.files.size() < 1) {
            throw new CorruptedEnvelopeException("Envelope body must contain permission and/or location information for at least one file");
        }
        this.valid = true;
    }

    public long getCreationTime() {
        return this.created;
    }

    public Date getCreationDate() {
        return new Date(this.getCreationTime());
    }

    public String getCreator() {
        return this.creator;
    }

    public long getExpirationTime() {
        return this.expires;
    }

    public Date getExpirationDate() {
        return this.expires == 0L ? null : new Date(this.getExpirationTime());
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<GridFile> getFiles() {
        return this.files;
    }

    public String toString() {
        return String.format("Envelope[%s,%d,%d,%s,%s]", this.creator, this.created, this.expires, this.files, filePermissions);
    }

    static {
        for (XrootdProtocol.FilePerm fp : XrootdProtocol.FilePerm.values()) {
            filePermissions.put(fp.xmlText(), fp);
        }
    }

    public class GridFile {
        private String lfn;
        private int access;
        private String turlString;
        private URI turl;
        private String turlProtocol;
        private InetAddress turlHost;

        public GridFile(String lfn, String turl, String access) throws CorruptedEnvelopeException {
            this.lfn = lfn;
            this.turlString = turl;
            if (!filePermissions.containsKey(access)) {
                throw new CorruptedEnvelopeException("file permisson flag for lfn " + lfn + " must be one out of 'read', 'write-once', 'write' or 'delete'");
            }
            this.access = filePermissions.get(access).ordinal();
            try {
                this.turl = this.parseTurl();
                this.turlHost = InetAddress.getByName(this.turl.getHost());
            }
            catch (URISyntaxException e) {
                throw new CorruptedEnvelopeException("Malformed TURL: " + e.getMessage());
            }
            catch (UnknownHostException e) {
                throw new CorruptedEnvelopeException(e.getMessage());
            }
        }

        private URI parseTurl() throws URISyntaxException {
            String rootURLString = this.getTurl();
            if (!rootURLString.toLowerCase().startsWith("root://")) {
                throw new URISyntaxException(rootURLString, "TURL does not start with root://");
            }
            this.turlProtocol = "root";
            return new URI(rootURLString);
        }

        public int getAccess() {
            return this.access;
        }

        public String getLfn() {
            return this.lfn;
        }

        public String getTurl() {
            return this.turlString;
        }

        public String getTurlProtocol() {
            return this.turlProtocol;
        }

        public InetAddress getTurlHost() {
            return this.turlHost;
        }

        public int getTurlPort() {
            return this.turl.getPort();
        }

        public String getTurlPath() {
            return this.turl.getPath();
        }

        public String getUserInfo() {
            return this.turl.getUserInfo();
        }

        public String toString() {
            return String.format("GridFile[%s,%d,%s]", this.lfn, this.access, this.turlString);
        }
    }
}

