/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.alice;

import java.io.File;
import java.net.InetSocketAddress;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import org.dcache.xrootd.plugins.AuthorizationHandler;
import org.dcache.xrootd.plugins.alice.CorruptedEnvelopeException;
import org.dcache.xrootd.plugins.alice.EncryptedAuthzToken;
import org.dcache.xrootd.plugins.alice.Envelope;
import org.dcache.xrootd.plugins.alice.TokenAuthorization1Factory;
import org.dcache.xrootd.protocol.XrootdProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenAuthorization1
implements AuthorizationHandler {
    private final Map<String, KeyPair> keystore;

    public TokenAuthorization1(Map<String, KeyPair> keystore) {
        this.keystore = keystore;
    }

    public String authorize(Subject subject, InetSocketAddress localAddress, InetSocketAddress remoteAddress, String path, Map<String, String> opaque, int request, XrootdProtocol.FilePerm mode) throws SecurityException, GeneralSecurityException {
        int turlPort;
        Envelope env;
        if (path == null) {
            throw new IllegalArgumentException("the lfn string must not be null");
        }
        String authzTokenString = opaque.get("authz");
        if (authzTokenString == null) {
            if (request == 3017 || request == 3022) {
                return path;
            }
            throw new GeneralSecurityException("No authorization token found in open request, access denied.");
        }
        KeyPair keypair = this.getKeys(opaque.get("vo"));
        try {
            env = this.decodeEnvelope(authzTokenString, keypair);
        }
        catch (CorruptedEnvelopeException e) {
            throw new GeneralSecurityException("Error parsing authorization token: " + e.getMessage());
        }
        Envelope.GridFile file = this.findFile(path, env);
        if (file == null) {
            throw new GeneralSecurityException("authorization token doesn't contain any file permissions for lfn " + path);
        }
        if (!Arrays.equals(file.getTurlHost().getAddress(), localAddress.getAddress().getAddress())) {
            throw new GeneralSecurityException("Hostname mismatch in authorization token (lfn=" + file.getLfn() + " TURL=" + file.getTurl() + ")");
        }
        int n = turlPort = file.getTurlPort() == -1 ? 1094 : file.getTurlPort();
        if (turlPort != localAddress.getPort()) {
            throw new GeneralSecurityException("Port mismatch in authorization token (lfn=" + file.getLfn() + " TURL=" + file.getTurl() + ")");
        }
        int grantedPermission = file.getAccess();
        if (mode == XrootdProtocol.FilePerm.WRITE ? grantedPermission < XrootdProtocol.FilePerm.WRITE_ONCE.ordinal() : mode == XrootdProtocol.FilePerm.DELETE && grantedPermission < XrootdProtocol.FilePerm.DELETE.ordinal()) {
            throw new AccessControlException("Token lacks authorization for requested operation");
        }
        return file.getTurlPath();
    }

    private Envelope.GridFile findFile(String path, Envelope env) {
        for (Envelope.GridFile file : env.getFiles()) {
            if (!path.equals(file.getLfn())) continue;
            return file;
        }
        return null;
    }

    private Envelope decodeEnvelope(String authzTokenString, KeyPair keypair) throws GeneralSecurityException, CorruptedEnvelopeException {
        EncryptedAuthzToken token = new EncryptedAuthzToken(authzTokenString, (RSAPrivateKey)keypair.getPrivate(), (RSAPublicKey)keypair.getPublic());
        token.decrypt();
        return token.getEnvelope();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyPair getKeys(String vo) throws GeneralSecurityException {
        if (this.keystore == null) {
            throw new GeneralSecurityException("no keystore found");
        }
        if (vo != null) {
            if (!this.keystore.containsKey(vo)) throw new GeneralSecurityException("no keypair for VO " + vo + " found in keystore");
            return this.keystore.get(vo);
        }
        if (!this.keystore.containsKey("*")) throw new GeneralSecurityException("no default keypair found in keystore, required for decoding authorization token");
        return this.keystore.get("*");
    }

    public static void main(String[] args) throws Exception {
        TokenAuthorization1Factory factory = new TokenAuthorization1Factory(new File(args[0]));
        String token = args[1];
        TokenAuthorization1 handler = factory.createHandler();
        System.out.println(handler.decodeEnvelope(token, handler.getKeys(null)));
    }
}

