/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.alice;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.AuthorizationHandler;
import org.dcache.xrootd.plugins.alice.CorruptedEnvelopeException;
import org.dcache.xrootd.plugins.alice.EncryptedAuthzToken;
import org.dcache.xrootd.plugins.alice.Envelope;
import org.dcache.xrootd.plugins.alice.TokenAuthorization1Factory;
import org.dcache.xrootd.protocol.XrootdProtocol;

public class TokenAuthorization1
implements AuthorizationHandler {
    private final Map<String, KeyPair> keystore;

    public TokenAuthorization1(Map<String, KeyPair> keystore) {
        this.keystore = (Map)Preconditions.checkNotNull(keystore);
    }

    public String authorize(Subject subject, InetSocketAddress localAddress, InetSocketAddress remoteAddress, String path, Map<String, String> opaque, int request, XrootdProtocol.FilePerm mode) throws XrootdException {
        Envelope env;
        if (path == null) {
            throw new IllegalArgumentException("The lfn string must not be null.");
        }
        String authzTokenString = opaque.get("authz");
        if (authzTokenString == null) {
            if (request == 3017 || request == 3022 || request == 3004) {
                return path;
            }
            throw new XrootdException(3010, "An authorization token is required for this request.");
        }
        KeyPair keypair = this.getKeys(opaque.get("vo"));
        try {
            env = this.decodeEnvelope(authzTokenString, keypair);
        }
        catch (InvalidKeyException | SignatureException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | CorruptedEnvelopeException e) {
            throw new XrootdException(3000, "Error parsing authorization token: " + e.getMessage());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new XrootdException(3012, "Error parsing authorization token: " + e.getMessage());
        }
        catch (CredentialException e) {
            throw new XrootdException(3010, "Error parsing authorization token: " + e.getMessage());
        }
        Envelope.GridFile file = this.findFile(path, env);
        if (file == null) {
            throw new XrootdException(3010, "Authorization token doesn't contain any file permissions for lfn " + path + ".");
        }
        try {
            if (!Arrays.asList(InetAddress.getAllByName(file.getTurl().getHost())).contains(localAddress.getAddress())) {
                throw new XrootdException(3010, "Hostname mismatch in authorization token (address=" + localAddress + " turl=" + file.getTurl() + ").");
            }
        }
        catch (UnknownHostException e) {
            throw new XrootdException(3010, "Hostname in authorization token is not resolvable (turl=" + file.getTurl() + ").");
        }
        int turlPort = file.getTurl().getPort();
        if (turlPort == -1) {
            turlPort = 1094;
        }
        if (turlPort != localAddress.getPort()) {
            throw new XrootdException(3010, "Port mismatch in authorization token (address=" + localAddress + " turl=" + file.getTurl() + ").");
        }
        XrootdProtocol.FilePerm grantedPermission = file.getAccess();
        if (mode == XrootdProtocol.FilePerm.WRITE ? grantedPermission.ordinal() < XrootdProtocol.FilePerm.WRITE_ONCE.ordinal() : mode == XrootdProtocol.FilePerm.DELETE && grantedPermission.ordinal() < XrootdProtocol.FilePerm.DELETE.ordinal()) {
            throw new XrootdException(3010, "Token lacks authorization for requested operation.");
        }
        return file.getTurl().getPath();
    }

    private Envelope.GridFile findFile(String path, Envelope env) {
        for (Envelope.GridFile file : env.getFiles()) {
            if (!path.equals(file.getLfn())) continue;
            return file;
        }
        return null;
    }

    private Envelope decodeEnvelope(String authzTokenString, KeyPair keypair) throws CorruptedEnvelopeException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, SignatureException, NoSuchProviderException, InvalidKeyException, CredentialException {
        EncryptedAuthzToken token = new EncryptedAuthzToken(authzTokenString, (RSAPrivateKey)keypair.getPrivate(), (RSAPublicKey)keypair.getPublic());
        return new Envelope(token.decrypt());
    }

    private KeyPair getKeys(String vo) throws XrootdException {
        KeyPair keypair;
        if (vo != null) {
            keypair = this.keystore.get(vo);
            if (keypair == null) {
                throw new XrootdException(3010, "VO " + vo + " is not authorized.");
            }
        } else {
            keypair = this.keystore.get("*");
            if (keypair == null) {
                throw new XrootdException(3010, "No default VO configured in key store; VO is required.");
            }
        }
        return keypair;
    }

    public static void main(String[] args) throws Exception {
        TokenAuthorization1Factory factory = new TokenAuthorization1Factory(new File(args[0]));
        String token = args[1];
        TokenAuthorization1 handler = factory.createHandler();
        System.out.println(handler.decodeEnvelope(token, handler.getKeys(null)));
    }
}

