/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.alice;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.CredentialExpiredException;
import org.dcache.xrootd.plugins.alice.CorruptedEnvelopeException;
import org.dcache.xrootd.protocol.XrootdProtocol;

public class Envelope {
    private String creator;
    private long created;
    private long expires;
    private boolean valid = false;
    private List<GridFile> files = new LinkedList<GridFile>();
    private static final String ENVELOPE_START = "-----BEGIN ENVELOPE-----";
    private static final String ENVELOPE_STOP = "-----END ENVELOPE-----";
    private static final String BODY_START = "-----BEGIN ENVELOPE BODY-----";
    private static final String BODY_STOP = "-----END ENVELOPE BODY-----";
    public static final Map<String, XrootdProtocol.FilePerm> filePermissions = new HashMap<String, XrootdProtocol.FilePerm>();
    private static final long TIME_OFFSET = 60L;
    Stack stack = new Stack();

    public Envelope(String envelope) throws CorruptedEnvelopeException, CredentialException {
        this.parse(envelope);
        this.checkValidity();
    }

    private void parse(String envelope) throws CorruptedEnvelopeException {
        LineNumberReader input = new LineNumberReader(new StringReader(envelope));
        try {
            String line;
            while ((line = input.readLine()) != null) {
                if (line.equals(ENVELOPE_START)) {
                    this.stack.push(ENVELOPE_START);
                    continue;
                }
                if (line.equals(ENVELOPE_STOP)) {
                    if (!this.stack.peek().equals(ENVELOPE_START)) {
                        throw new CorruptedEnvelopeException("Parse error near -----END ENVELOPE-----");
                    }
                    this.stack.pop();
                    continue;
                }
                if (line.equals(BODY_START)) {
                    this.stack.push(BODY_START);
                    continue;
                }
                if (line.equals(BODY_STOP)) {
                    if (!this.stack.peek().equals(BODY_START)) {
                        throw new CorruptedEnvelopeException("Parse error near -----END ENVELOPE BODY-----");
                    }
                    this.stack.pop();
                    continue;
                }
                if (this.stack.empty() || "".equals(line)) continue;
                if (this.stack.peek().equals(ENVELOPE_START)) {
                    this.parseHeader(line);
                    continue;
                }
                if (!this.stack.peek().equals(BODY_START)) continue;
                StringBuffer xmlBody = new StringBuffer(line);
                while (!line.equals("</authz>") && (line = input.readLine()) != null) {
                    xmlBody.append(line);
                }
                this.parseBody(xmlBody.toString());
            }
        }
        catch (IOException e) {
            throw new CorruptedEnvelopeException("Error reading from envelope String while parsing");
        }
        try {
            input.close();
        }
        catch (IOException e) {
            throw new CorruptedEnvelopeException("Error closing stream where envelope string was parsed from");
        }
    }

    private void parseHeader(String line) {
        String key;
        StringTokenizer tokenizer = new StringTokenizer(line, ": ");
        try {
            key = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            return;
        }
        if (key.equals("CREATOR")) {
            this.creator = tokenizer.nextToken();
            return;
        }
        if (key.equals("UNIXTIME")) {
            this.created = Long.parseLong(tokenizer.nextToken());
            return;
        }
        if (key.equals("EXPIRES")) {
            this.expires = Long.parseLong(tokenizer.nextToken());
            return;
        }
    }

    private void parseBody(String xmlBody) throws CorruptedEnvelopeException {
        String[] tags = new String[]{"authz", "file", "lfn", "turl", "access"};
        StringTokenizer tokenizer = new StringTokenizer(xmlBody, "<> ");
        String tmpLfn = null;
        String tmpTURL = null;
        String tmpPerm = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(tags[0])) {
                this.stack.push(tags[0]);
                continue;
            }
            if (this.stack.peek().equals(tags[0]) && token.equals("/" + tags[0])) {
                this.stack.pop();
                continue;
            }
            if (this.stack.peek().equals(tags[0]) && token.equals(tags[1])) {
                this.stack.push(tags[1]);
                tmpPerm = null;
                tmpTURL = null;
                tmpLfn = null;
                continue;
            }
            if (this.stack.peek().equals(tags[1]) && token.equals("/" + tags[1])) {
                this.stack.pop();
                this.files.add(new GridFile(tmpLfn, tmpTURL, tmpPerm));
                if (filePermissions.containsKey(tmpPerm)) continue;
                throw new CorruptedEnvelopeException("unknown access parameter for lfn " + tmpLfn + ": " + tmpPerm);
            }
            if (this.stack.peek().equals(tags[1]) && token.equals(tags[2])) {
                tmpLfn = tokenizer.nextToken();
                if (tokenizer.nextToken().equals("/" + tags[2])) continue;
                throw new CorruptedEnvelopeException("Parse error near: " + tmpLfn);
            }
            if (this.stack.peek().equals(tags[1]) && token.equals(tags[3])) {
                tmpTURL = tokenizer.nextToken();
                if (tokenizer.nextToken().equals("/" + tags[3])) continue;
                throw new CorruptedEnvelopeException("Parse error near: " + tmpTURL);
            }
            if (!this.stack.peek().equals(tags[1]) || !token.equals(tags[4])) continue;
            tmpPerm = tokenizer.nextToken();
            if (tokenizer.nextToken().equals("/" + tags[4])) continue;
            throw new CorruptedEnvelopeException("Parse error near: " + tmpPerm);
        }
    }

    private void checkValidity() throws CorruptedEnvelopeException, CredentialException {
        long current = System.currentTimeMillis() / 1000L;
        if (this.created - 60L > current) {
            throw new CredentialException("Envelope creation time lies in the future: " + new Date(this.created * 1000L));
        }
        if (this.expires != 0L && current > this.expires) {
            throw new CredentialExpiredException("Envelope expired " + new Date(this.expires * 1000L));
        }
        if (this.files.size() < 1) {
            throw new CorruptedEnvelopeException("Envelope body must contain permission and/or location information for at least one file");
        }
        this.valid = true;
    }

    public long getCreationTime() {
        return this.created;
    }

    public Date getCreationDate() {
        return new Date(this.getCreationTime());
    }

    public String getCreator() {
        return this.creator;
    }

    public long getExpirationTime() {
        return this.expires;
    }

    public Date getExpirationDate() {
        return this.expires == 0L ? null : new Date(this.getExpirationTime());
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<GridFile> getFiles() {
        return this.files;
    }

    public String toString() {
        return String.format("Envelope[%s,%d,%d,%s]", this.creator, this.created, this.expires, this.files);
    }

    static {
        for (XrootdProtocol.FilePerm fp : XrootdProtocol.FilePerm.values()) {
            filePermissions.put(fp.xmlText(), fp);
        }
    }

    public class GridFile {
        private String lfn;
        private XrootdProtocol.FilePerm access;
        private URI turl;

        public GridFile(String lfn, String turl, String access) throws CorruptedEnvelopeException {
            this.lfn = lfn;
            if (!filePermissions.containsKey(access)) {
                throw new CorruptedEnvelopeException("file permisson flag for lfn " + lfn + " must be one out of 'read', 'write-once', 'write' or 'delete'");
            }
            this.access = filePermissions.get(access);
            try {
                this.turl = this.parseTurl(turl);
            }
            catch (URISyntaxException e) {
                throw new CorruptedEnvelopeException("Malformed TURL: " + e.getMessage());
            }
        }

        private URI parseTurl(String turl) throws URISyntaxException {
            URI uri = new URI(turl);
            if (!uri.getScheme().equalsIgnoreCase("root")) {
                throw new URISyntaxException(turl, "TURL does not start with root://");
            }
            return uri;
        }

        public XrootdProtocol.FilePerm getAccess() {
            return this.access;
        }

        public String getLfn() {
            return this.lfn;
        }

        public URI getTurl() {
            return this.turl;
        }

        public String toString() {
            return String.format("GridFile[%s,%s,%s]", this.lfn, this.access, this.turl);
        }
    }
}

