/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.alice;

import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.dcache.xrootd.plugins.AuthorizationFactory;
import org.dcache.xrootd.plugins.alice.TokenAuthorization1;
import org.dcache.xrootd.util.ParseException;

public class TokenAuthorization1Factory
implements AuthorizationFactory {
    static final String NAME = "alice-token-1";
    static final Set<String> NAMES = new HashSet<String>(Arrays.asList("alice-token-1", "alice-token", "org.dcache.xrootd2.security.plugins.tokenauthz.TokenAuthorizationFactory"));
    protected final Map<String, KeyPair> _keystore;

    public TokenAuthorization1Factory(File keystoreFile) throws ParseException, IOException {
        this._keystore = this.loadKeyStore(keystoreFile);
    }

    static boolean hasName(String name) {
        return NAMES.contains(name);
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "Alice token authorization (does not apply to stat or statx)";
    }

    public TokenAuthorization1 createHandler(ChannelHandlerContext ctx) {
        return new TokenAuthorization1(this._keystore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, KeyPair> loadKeyStore(File file) throws ParseException, IOException {
        try (LineNumberReader in = new LineNumberReader(new FileReader(file));){
            HashMap<String, KeyPair> keystore = new HashMap<String, KeyPair>();
            KeyFactory keyFactory = null;
            try {
                keyFactory = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to initialize RSA key factory" + e.getMessage());
            }
            String line = null;
            while ((line = in.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, " \t");
                String voToken = null;
                String privKeyToken = null;
                String pubKeyToken = null;
                try {
                    String firstToken = tokenizer.nextToken();
                    if (firstToken.startsWith("#") || !firstToken.equals("KEY")) continue;
                    voToken = tokenizer.nextToken();
                    privKeyToken = tokenizer.nextToken();
                    pubKeyToken = tokenizer.nextToken();
                }
                catch (NoSuchElementException e) {
                    throw new ParseException("line no " + in.getLineNumber() + " : invalid format");
                }
                if (!(voToken.startsWith("VO:") && privKeyToken.startsWith("PRIVKEY:") && pubKeyToken.startsWith("PUBKEY:"))) {
                    throw new ParseException("line no " + in.getLineNumber() + " : invalid format");
                }
                keystore.put(voToken.substring(voToken.indexOf(58) + 1), this.loadKeyPair(privKeyToken.substring(privKeyToken.indexOf(58) + 1), pubKeyToken.substring(pubKeyToken.indexOf(58) + 1), keyFactory));
            }
            HashMap<String, KeyPair> hashMap = keystore;
            return hashMap;
        }
    }

    private KeyPair loadKeyPair(String privKeyFileName, String pubKeyFileName, KeyFactory keyFactory) throws IOException {
        RSAPublicKey pubKey;
        RSAPrivateKey privKey;
        File privKeyFile = new File(privKeyFileName);
        File pubKeyFile = new File(pubKeyFileName);
        byte[] privKeyArray = TokenAuthorization1Factory.readKeyfile(privKeyFile);
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privKeyArray);
        try {
            privKey = (RSAPrivateKey)keyFactory.generatePrivate(privKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("error loading private key " + privKeyFileName + ": " + e.getMessage());
        }
        byte[] pubKeyArray = TokenAuthorization1Factory.readKeyfile(pubKeyFile);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyArray);
        try {
            pubKey = (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("error loading public key " + pubKeyFileName + ": " + e.getMessage());
        }
        return new KeyPair(pubKey, privKey);
    }

    private static byte[] readKeyfile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        byte[] result = new byte[(int)file.length()];
        int bytesRead = 0;
        while ((long)(bytesRead += ((InputStream)in).read(result, bytesRead, (int)file.length() - bytesRead)) < file.length()) {
        }
        if ((long)bytesRead != file.length()) {
            throw new IOException("Keyfile " + file.getName() + " corrupt.");
        }
        ((InputStream)in).close();
        return result;
    }
}

