/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class CertUtil {
    private static Map<X500Principal, String> _hashCache = new ConcurrentHashMap<X500Principal, String>();

    public static byte[] fromPEM(String pem, String header, String footer) {
        if (!pem.startsWith(header)) {
            throw new IllegalArgumentException("The provided PEM string doesn't start with '" + header + "'");
        }
        StringBuilder sb = new StringBuilder(pem);
        sb.delete(0, header.length());
        CertUtil.removeChar(sb, '\n');
        if (!sb.subSequence(sb.length() - footer.length(), sb.length()).equals(footer)) {
            throw new IllegalArgumentException("The provided PEM string doesn't end with '" + footer + "'");
        }
        sb.delete(sb.indexOf(footer), sb.length());
        return Base64.decodeBase64((String)sb.toString());
    }

    public static String certToPEM(byte[] der) {
        return CertUtil.toPEM(der, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
    }

    public static String toPEM(byte[] der, String header, String footer) {
        StringBuilder result = new StringBuilder(header);
        if (header.charAt(header.length() - 1) != '\n') {
            result.append('\n');
        }
        String base64 = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])der));
        int pos = 0;
        while (pos + 64 < base64.length()) {
            result.append(base64.substring(pos, pos + 64));
            result.append('\n');
            pos += 64;
        }
        result.append(base64.substring(pos));
        result.append('\n');
        result.append(footer);
        if (footer.charAt(footer.length() - 1) != '\n') {
            result.append('\n');
        }
        return result.toString();
    }

    public static String computeMD5Hash(X500Principal principal) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
        return CertUtil.computeHash(md, principal);
    }

    public static String computeHash(MessageDigest md, X500Principal principal) {
        String principalHash;
        if (_hashCache.containsKey(principal)) {
            principalHash = _hashCache.get(principal);
        } else {
            md.reset();
            md.update(principal.getEncoded());
            byte[] md5hash = md.digest();
            int shortHash = (0xFF & md5hash[3]) << 24 | (0xFF & md5hash[2]) << 16 | (0xFF & md5hash[1]) << 8 | 0xFF & md5hash[0];
            principalHash = Integer.toHexString(shortHash);
            _hashCache.put(principal, principalHash);
        }
        return principalHash;
    }

    private static StringBuilder removeChar(StringBuilder sb, char c) {
        int index;
        while ((index = sb.indexOf("\n")) > -1) {
            sb.deleteCharAt(index);
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<X509Certificate> parseCerts(Reader in) throws IOException, GeneralSecurityException {
        if (in == null) {
            throw new IllegalArgumentException("no inputstream given");
        }
        LinkedList<X509Certificate> list = new LinkedList<X509Certificate>();
        X509Certificate cert = null;
        BufferedReader reader = new BufferedReader(in);
        try {
            while ((cert = org.globus.gsi.CertUtil.readCertificate((BufferedReader)reader)) != null) {
                list.add(cert);
            }
        }
        finally {
            reader.close();
        }
        if (list.isEmpty()) {
            throw new GeneralSecurityException("no certificates found");
        }
        return list;
    }
}

