/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;
import org.globus.common.CoGProperties;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.ProviderLoader;
import org.globus.gsi.X509Credential;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.provider.KeyStoreParametersFactory;
import org.globus.gsi.stores.ResourceCertStoreParameters;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.ResourceSigningPolicyStoreParameters;
import org.globus.gsi.trustmanager.X509ProxyCertPathValidator;
import org.globus.gsi.util.CertificateUtil;

public class GlobusCredential
implements Serializable {
    private Log logger = LogFactory.getLog(this.getClass());
    private X509Credential cred;
    private static GlobusCredential defaultCred;
    private static transient long credentialLastModified;
    private static transient boolean credentialSet;
    private static transient File credentialFile;

    public GlobusCredential(PrivateKey key, X509Certificate[] certs) {
        this.cred = new X509Credential(key, certs);
    }

    public GlobusCredential(String proxyFile) throws GlobusCredentialException {
        try {
            this.cred = new X509Credential(proxyFile);
        }
        catch (Exception e) {
            throw new GlobusCredentialException(-1, e.getMessage(), e);
        }
    }

    public GlobusCredential(String certFile, String unencryptedKeyFile) throws GlobusCredentialException {
        if (certFile == null || unencryptedKeyFile == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.cred = new X509Credential(certFile, unencryptedKeyFile);
        }
        catch (Exception e) {
            throw new GlobusCredentialException(-1, e.getMessage(), e);
        }
    }

    public GlobusCredential(InputStream input) throws GlobusCredentialException {
        try {
            this.cred = new X509Credential(input);
        }
        catch (Exception e) {
            throw new GlobusCredentialException(-1, e.getMessage(), e);
        }
    }

    public void save(OutputStream out) throws IOException {
        try {
            this.cred.save(out);
        }
        catch (CertificateEncodingException e) {
            throw new ChainedIOException(e.getMessage(), e);
        }
    }

    public void verify() throws GlobusCredentialException {
        try {
            String caCertsLocation = "file:" + CoGProperties.getDefault().getCaCertLocations();
            String crlPattern = caCertsLocation + "/*.r*";
            String sigPolPattern = caCertsLocation + "/*.signing_policy";
            KeyStore keyStore = KeyStore.getInstance("PEMFilebasedKeyStore", "Globus");
            CertStore crlStore = CertStore.getInstance("PEMFilebasedCertStore", new ResourceCertStoreParameters(null, crlPattern));
            ResourceSigningPolicyStore sigPolStore = new ResourceSigningPolicyStore(new ResourceSigningPolicyStoreParameters(sigPolPattern));
            keyStore.load(KeyStoreParametersFactory.createTrustStoreParameters(caCertsLocation));
            X509ProxyCertPathParameters parameters = new X509ProxyCertPathParameters(keyStore, crlStore, sigPolStore, false);
            X509ProxyCertPathValidator validator = new X509ProxyCertPathValidator();
            validator.engineValidate(CertificateUtil.getCertPath(this.cred.getCertificateChain()), parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GlobusCredentialException(-1, e.getMessage(), e);
        }
    }

    public X509Certificate getIdentityCertificate() {
        return this.cred.getIdentityCertificate();
    }

    public int getPathConstraint() {
        return this.cred.getPathConstraint();
    }

    public String getIdentity() {
        return this.cred.getIdentity();
    }

    public PrivateKey getPrivateKey() {
        try {
            return this.cred.getPrivateKey();
        }
        catch (Exception e) {
            return null;
        }
    }

    public X509Certificate[] getCertificateChain() {
        return this.cred.getCertificateChain();
    }

    public int getCertNum() {
        return this.cred.getCertNum();
    }

    public int getStrength() {
        try {
            return this.cred.getStrength();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getSubject() {
        return this.cred.getSubject();
    }

    public String getIssuer() {
        return this.cred.getIssuer();
    }

    public int getProxyType() {
        return this.cred.getProxyType().getCode();
    }

    public long getTimeLeft() {
        return this.cred.getTimeLeft();
    }

    public static synchronized GlobusCredential getDefaultCredential() throws GlobusCredentialException {
        if (defaultCred == null) {
            GlobusCredential.reloadDefaultCredential();
        } else if (!credentialSet) {
            if (credentialFile.lastModified() == credentialLastModified) {
                defaultCred.verify();
            } else {
                defaultCred = null;
                GlobusCredential.reloadDefaultCredential();
            }
        }
        return defaultCred;
    }

    private static void reloadDefaultCredential() throws GlobusCredentialException {
        String proxyLocation = CoGProperties.getDefault().getProxyFile();
        defaultCred = new GlobusCredential(proxyLocation);
        credentialFile = new File(proxyLocation);
        credentialLastModified = credentialFile.lastModified();
        defaultCred.verify();
    }

    public static synchronized void setDefaultCredential(GlobusCredential cred) {
        credentialSet = cred != null;
    }

    public String toString() {
        return this.cred.toString();
    }

    static {
        credentialLastModified = -1L;
        credentialSet = false;
        credentialFile = null;
        new ProviderLoader();
    }
}

