/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.DHSession;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.AuthenticationResponse;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.security.NestedBucketBuffer;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.StringBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSIAuthenticationHandler
implements AuthenticationHandler {
    public static final String PROTOCOL = "gsi";
    public static final String PROTOCOL_VERSION = "10200";
    public static final String CRYPTO_MODE = "ssl";
    public static final String SUPPORTED_CIPHER_ALGORITHMS = "aes-128-cbc";
    public static final String SUPPORTED_DIGESTS = "sha1:md5";
    private static final Logger _logger = LoggerFactory.getLogger(GSIAuthenticationHandler.class);
    private static final String SERVER_ASYNC_CIPHER_MODE = "RSA/NONE/PKCS1Padding";
    private static final String SERVER_SYNC_CIPHER_MODE = "AES/CBC/PKCS5Padding";
    private static final String SERVER_SYNC_CIPHER_NAME = "AES";
    private static final int SERVER_SYNC_CIPHER_BLOCKSIZE = 16;
    private static final int CHALLENGE_BYTES = 8;
    private static final SecureRandom _random = new SecureRandom();
    private static final ProxyPathValidator _proxyValidator = new ProxyPathValidator();
    private final TrustedCertificates _trustedCerts;
    private final X509Certificate _hostCertificate;
    private final PrivateKey _hostKey;
    private final CertificateRevocationLists _crls;
    private String _challenge = "";
    private Cipher _challengeCipher;
    private DHSession _dhSession;
    private final Subject _subject;
    private boolean _finished = false;

    public GSIAuthenticationHandler(X509Certificate hostCertificate, PrivateKey privateKey, TrustedCertificates trustedCerts, CertificateRevocationLists crls) {
        this._hostCertificate = hostCertificate;
        this._hostKey = privateKey;
        this._trustedCerts = trustedCerts;
        this._crls = crls;
        this._subject = new Subject();
    }

    public AbstractResponseMessage authenticate(AuthenticationRequest request) throws XrootdException {
        try {
            if (this._dhSession == null) {
                this._dhSession = new DHSession();
            }
        }
        catch (GeneralSecurityException gssex) {
            _logger.error("Error setting up cryptographic classes: {}", (Throwable)gssex);
            throw new XrootdException(3012, "Server probably misconfigured.");
        }
        if (!PROTOCOL.equalsIgnoreCase(request.getProtocol())) {
            throw new XrootdException(3006, "Specified Protocol " + request.getProtocol() + " is not the protocol that was negotiated.");
        }
        switch (request.getStep()) {
            case 0: {
                return new OkResponse((XrootdRequest)request);
            }
            case 1000: {
                return this.handleCertReqStep(request);
            }
            case 1001: {
                return this.handleCertStep(request);
            }
        }
        throw new XrootdException(3006, "Error during authentication, unknown processing step: " + request.getStep());
    }

    private AbstractResponseMessage handleCertReqStep(AuthenticationRequest request) throws XrootdException {
        try {
            this._challengeCipher = Cipher.getInstance(SERVER_ASYNC_CIPHER_MODE, "BC");
            this._challengeCipher.init(1, this._hostKey);
            Map buckets = request.getBuckets();
            NestedBucketBuffer buffer = (NestedBucketBuffer)buckets.get(XrootdSecurityProtocol.BucketType.kXRS_main);
            StringBucket rtagBucket = (StringBucket)buffer.getNestedBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_rtag);
            String rtag = rtagBucket.getContent();
            this._challengeCipher.update(rtag.getBytes());
            byte[] signedRtag = this._challengeCipher.doFinal();
            this._challenge = this.generateChallengeString();
            byte[] puk = this._dhSession.getEncodedDHMaterial().getBytes();
            String hostCertificateString = CertUtil.certToPEM(this._hostCertificate.getEncoded());
            XrootdBucketContainer responseBuckets = this.buildCertReqResponse(signedRtag, this._challenge, CRYPTO_MODE, puk, SUPPORTED_CIPHER_ALGORITHMS, SUPPORTED_DIGESTS, hostCertificateString);
            return new AuthenticationResponse((XrootdRequest)request, 4002, responseBuckets.getSize(), PROTOCOL, 2001, responseBuckets.getBuckets());
        }
        catch (InvalidKeyException ikex) {
            _logger.error("Configured host-key could not be used forsigning rtag: {}", (Throwable)ikex);
            throw new XrootdException(3012, "Internal error occured when trying to sign client authentication tag.");
        }
        catch (CertificateEncodingException cee) {
            _logger.error("Could not extract contents of server certificate: {}", (Throwable)cee);
            throw new XrootdException(3012, "Internal error occured when trying to send server certificate.");
        }
        catch (GeneralSecurityException gssex) {
            _logger.error("Problems during signing of client authN tag (algorithm {}): {}", (Object)SERVER_ASYNC_CIPHER_MODE, (Object)gssex);
            throw new XrootdException(3012, "Internal error occured when trying to sign client authentication tag.");
        }
    }

    private AbstractResponseMessage handleCertStep(AuthenticationRequest request) throws XrootdException {
        try {
            Map receivedBuckets = request.getBuckets();
            RawBucket encryptedBucket = (RawBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_main);
            byte[] encrypted = encryptedBucket.getContent();
            StringBucket dhMessage = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_puk);
            this._dhSession.finaliseKeyAgreement(dhMessage.getContent());
            byte[] decrypted = this._dhSession.decrypt(SERVER_SYNC_CIPHER_MODE, SERVER_SYNC_CIPHER_NAME, 16, encrypted);
            ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])decrypted);
            NestedBucketBuffer nestedBucket = NestedBucketBuffer.deserialize((XrootdSecurityProtocol.BucketType)XrootdSecurityProtocol.BucketType.kXRS_main, (ChannelBuffer)buffer);
            XrootdBucket clientX509Bucket = (XrootdBucket)nestedBucket.getNestedBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_x509);
            String clientX509 = ((StringBucket)clientX509Bucket).getContent();
            List<X509Certificate> clientCerts = CertUtil.parseCerts(new StringReader(clientX509));
            if (clientCerts.size() <= 1) {
                throw new IllegalArgumentException("Could not parse user certificate from input stream!");
            }
            X509Certificate proxyCert = clientCerts.get(0);
            _logger.info("The proxy-cert has the subject {} and the issuer {}", (Object)proxyCert.getSubjectDN(), (Object)proxyCert.getIssuerDN());
            X509Certificate[] proxyCertChain = clientCerts.toArray(new X509Certificate[clientCerts.size()]);
            this._subject.getPublicCredentials().add(proxyCertChain);
            _proxyValidator.validate(proxyCertChain, this._trustedCerts.getCertificates(), this._crls, this._trustedCerts.getSigningPolicies());
            this._challengeCipher.init(2, proxyCert.getPublicKey());
            XrootdBucket signedRTagBucket = (XrootdBucket)nestedBucket.getNestedBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag);
            byte[] signedRTag = ((RawBucket)signedRTagBucket).getContent();
            byte[] rTag = this._challengeCipher.doFinal(signedRTag);
            String rTagString = new String(rTag, "ASCII");
            if (!this._challenge.equals(rTagString)) {
                _logger.error("The challenge is {}, the serialized rTag is {}.signature of challenge tag has been proven wrong!!", (Object)this._challenge, (Object)rTagString);
                throw new XrootdException(3006, "Client did not present correctchallenge response!");
            }
            _logger.debug("signature of challenge tag ok. Challenge: {}, rTagString: {}", (Object)this._challenge, (Object)rTagString);
            this._finished = true;
            return new OkResponse((XrootdRequest)request);
        }
        catch (InvalidKeyException ikex) {
            _logger.error("The key negotiated by DH key exchange appears to be invalid: {}", (Throwable)ikex);
            throw new XrootdException(3006, "Could not decrypt clientinformation with negotiated key.");
        }
        catch (InvalidKeySpecException iksex) {
            _logger.error("DH key negotiation caused problems{}", (Throwable)iksex);
            throw new XrootdException(3006, "Could not find key negotiation parameters.");
        }
        catch (IOException ioex) {
            _logger.error("Could not deserialize main nested buffer {}", (Throwable)ioex);
            throw new XrootdException(3007, "Could not decrypt encrypted client message.");
        }
        catch (ProxyPathValidatorException ppvex) {
            _logger.error("Could not validate certificate path of client certificate: {}", (Throwable)ppvex);
            throw new XrootdException(3010, "Your certificate's issuer is not trusted.");
        }
        catch (GeneralSecurityException gssex) {
            _logger.error("Error during decrypting/server-side key exchange: {}", (Throwable)gssex);
            throw new XrootdException(3012, "Error in server-side cryptographic operations.");
        }
    }

    private XrootdBucketContainer buildCertReqResponse(byte[] signedChallenge, String newChallenge, String cryptoMode, byte[] puk, String supportedCiphers, String supportedDigests, String hostCertificate) {
        int responseLength = 0;
        ArrayList<XrootdBucket> responseList = new ArrayList<XrootdBucket>();
        RawBucket signedRtagBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag, signedChallenge);
        StringBucket randomTagBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_rtag, newChallenge);
        EnumMap<XrootdSecurityProtocol.BucketType, Object> nestedBuckets = new EnumMap<XrootdSecurityProtocol.BucketType, Object>(XrootdSecurityProtocol.BucketType.class);
        nestedBuckets.put(signedRtagBucket.getType(), (Object)signedRtagBucket);
        nestedBuckets.put(randomTagBucket.getType(), (Object)randomTagBucket);
        NestedBucketBuffer mainBucket = new NestedBucketBuffer(XrootdSecurityProtocol.BucketType.kXRS_main, PROTOCOL, 2001, nestedBuckets);
        StringBucket cryptoBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cryptomod, CRYPTO_MODE);
        responseLength += cryptoBucket.getSize();
        responseList.add((XrootdBucket)cryptoBucket);
        responseLength += mainBucket.getSize();
        responseList.add((XrootdBucket)mainBucket);
        RawBucket dhPublicBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_puk, puk);
        responseLength += dhPublicBucket.getSize();
        responseList.add((XrootdBucket)dhPublicBucket);
        StringBucket cipherBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg, supportedCiphers);
        responseLength += cipherBucket.getSize();
        responseList.add((XrootdBucket)cipherBucket);
        StringBucket digestBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_md_alg, supportedDigests);
        responseLength += digestBucket.getSize();
        responseList.add((XrootdBucket)digestBucket);
        StringBucket hostCertBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_x509, hostCertificate);
        responseList.add((XrootdBucket)hostCertBucket);
        return new XrootdBucketContainer(responseList, responseLength += hostCertBucket.getSize());
    }

    private String generateChallengeString() {
        String result;
        byte[] challengeBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            challengeBytes[i] = (byte)_random.nextInt(127);
        }
        try {
            result = new String(challengeBytes, "ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            result = new String(challengeBytes);
        }
        return result;
    }

    public String getProtocol() {
        String subjectHash = CertUtil.computeMD5Hash(this._hostCertificate.getIssuerX500Principal());
        return "&P=gsi,v:10200,c:ssl,ca:" + subjectHash;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public boolean isCompleted() {
        return this._finished;
    }

    class XrootdBucketContainer {
        private final int _size;
        private final List<XrootdBucket> _buckets;

        public XrootdBucketContainer(List<XrootdBucket> buckets, int size) {
            this._buckets = buckets;
            this._size = size;
        }

        public int getSize() {
            return this._size;
        }

        public List<XrootdBucket> getBuckets() {
            return this._buckets;
        }
    }
}

