/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.helpers.ocsp.BoundedSizeLruMap;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPCacheBase;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPClientImpl;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResponseStructure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.SingleResp;

public class OCSPResponsesCache
extends OCSPCacheBase {
    private Map<String, ResponseCacheEntry> responsesCache = Collections.synchronizedMap(new BoundedSizeLruMap(100));

    public OCSPResponsesCache(long maxTtl, File diskPath, String prefix) {
        super(maxTtl, diskPath, prefix);
    }

    public SingleResp getCachedResp(String responseKey, OCSPClientImpl client, X509Certificate toCheckCert, X509Certificate issuerCert) throws IOException {
        Date now;
        File f;
        ResponseCacheEntry cachedResp = this.responsesCache.get(responseKey);
        if (cachedResp == null && this.diskPath != null && (f = new File(this.diskPath, this.prefix + responseKey)).exists()) {
            cachedResp = this.loadResponseFromDisk(f, client, toCheckCert, issuerCert);
        }
        if (cachedResp == null) {
            return null;
        }
        Date nextUpdate = cachedResp.response != null ? cachedResp.response.getNextUpdate() : null;
        Date maxCacheValidity = new Date(cachedResp.cacheDate.getTime() + this.maxTtl);
        if (nextUpdate != null && maxCacheValidity.after(nextUpdate)) {
            maxCacheValidity = nextUpdate;
        }
        if (maxCacheValidity.after(cachedResp.maxValidity)) {
            maxCacheValidity = cachedResp.maxValidity;
        }
        if ((now = new Date()).after(maxCacheValidity)) {
            this.responsesCache.remove(responseKey);
            if (this.diskPath != null) {
                File f2 = new File(this.diskPath, this.prefix + responseKey);
                f2.delete();
            }
            return null;
        }
        return cachedResp.response;
    }

    public String createResponseKey(X509Certificate toCheckCert, X509Certificate issuerCert) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JDK problem: SHA-1 hash not supported by any provider!", e);
        }
        PublicKey issuerKey = issuerCert.getPublicKey();
        digest.update(issuerCert.getSubjectX500Principal().getEncoded());
        digest.update(issuerKey.getEncoded());
        digest.update(toCheckCert.getSerialNumber().toByteArray());
        return this.encodeDigest(digest);
    }

    public void addToCache(String key, OCSPResponseStructure fullResp, SingleResp singleResp) throws IOException {
        if (fullResp.getMaxCache() == null) {
            fullResp.setMaxCache(singleResp.getNextUpdate());
        }
        this.responsesCache.put(key, new ResponseCacheEntry(new Date(), fullResp.getMaxCache(), singleResp));
        if (this.diskPath != null) {
            File f = new File(this.diskPath, this.prefix + key);
            this.storeResponseToDisk(f, fullResp);
        }
    }

    public void clearMemoryCache() {
        this.responsesCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeResponseToDisk(File f, OCSPResponseStructure fullResp) throws IOException {
        if (f.exists()) {
            f.delete();
        }
        Date maxCache = fullResp.getMaxCache();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
        try {
            oos.writeObject(maxCache);
            oos.writeObject(fullResp.getResponse().getEncoded());
        }
        finally {
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseCacheEntry loadResponseFromDisk(File f, OCSPClientImpl client, X509Certificate toCheckCert, X509Certificate issuerCert) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(f));
            Date maxCache = (Date)ois.readObject();
            byte[] resp = (byte[])ois.readObject();
            OCSPResp fullResp = new OCSPResp(resp);
            SingleResp diskResp = client.verifyResponse(fullResp, toCheckCert, issuerCert, null);
            ResponseCacheEntry responseCacheEntry = new ResponseCacheEntry(new Date(f.lastModified()), maxCache, diskResp);
            return responseCacheEntry;
        }
        catch (Exception e) {
            f.delete();
            ResponseCacheEntry responseCacheEntry = null;
            return responseCacheEntry;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class ResponseCacheEntry {
        private Date cacheDate;
        private Date maxValidity;
        private SingleResp response;

        public ResponseCacheEntry(Date cacheDate, Date maxValidity, SingleResp response) {
            this.cacheDate = cacheDate;
            this.maxValidity = maxValidity;
            this.response = response;
        }
    }
}

