/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;

public class DHSession {
    private static final String DH_ALGORITHM_NAME = "DH";
    private static final String DH_HEADER = "-----BEGIN DH PARAMETERS-----";
    private static final String DH_FOOTER = "-----END DH PARAMETERS-----";
    private static final String DH_PUBKEY_HEADER = "---BPUB---";
    private static final String DH_PUBKEY_FOOTER = "---EPUB---";
    private static final String DH_PRIME = "00:a8:37:9d:6f:ff:e8:63:a0:b1:47:0c:26:dd:1a:45:0b:e2:03:9a:f0:83:b1:ba:5b:fa:1d:2f:5b:2a:89:08:02:d8:c4:d4:66:8d:14:8d:35:bb:24:b1:af:1a:d3:75:c7:c0:3b:61:aa:85:3f:56:69:ae:f2:67:da:20:87:5d:93".replaceAll("[:\\s]+", "");
    private static final DHParameterSpec DH_PARAMETERS = new DHParameterSpec(new BigInteger(DH_PRIME, 16), BigInteger.valueOf(2L));
    private KeyPair _localDHKeyPair;
    private KeyAgreement _keyAgreement;

    public DHSession() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        KeyPairGenerator kpairGen = KeyPairGenerator.getInstance(DH_ALGORITHM_NAME, "BC");
        kpairGen.initialize(DH_PARAMETERS);
        this._localDHKeyPair = kpairGen.generateKeyPair();
        this._keyAgreement = KeyAgreement.getInstance(DH_ALGORITHM_NAME, "BC");
        this._keyAgreement.init(this._localDHKeyPair.getPrivate());
    }

    public String getEncodedDHMaterial() {
        String dhparams = CertUtil.toPEM(this.toDER(DH_PARAMETERS), DH_HEADER, DH_FOOTER);
        DHPublicKey pubkey = (DHPublicKey)this._localDHKeyPair.getPublic();
        return dhparams + '\n' + DH_PUBKEY_HEADER + pubkey.getY().toString(16) + DH_PUBKEY_FOOTER;
    }

    public void finaliseKeyAgreement(String dhmessage) throws IOException, GeneralSecurityException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, IllegalStateException {
        int delimitingIndex = dhmessage.indexOf(DH_PUBKEY_HEADER);
        if (delimitingIndex < 0 || delimitingIndex >= dhmessage.length()) {
            throw new IllegalArgumentException("Illegal DH message: " + dhmessage);
        }
        String dhparams = dhmessage.substring(0, delimitingIndex);
        String remotePubKeyString = dhmessage.substring(delimitingIndex);
        DHParameterSpec params = this.fromDER(CertUtil.fromPEM(dhparams, DH_HEADER, DH_FOOTER));
        if (!DH_PARAMETERS.getP().equals(params.getP()) || !DH_PARAMETERS.getG().equals(params.getG())) {
            throw new GeneralSecurityException("remote DH parameters differ from local ones");
        }
        this.removeCharFromString(remotePubKeyString, '\n');
        int envLength = DH_PUBKEY_HEADER.length();
        remotePubKeyString = remotePubKeyString.substring(envLength, remotePubKeyString.length() - envLength);
        BigInteger remoteY = new BigInteger(remotePubKeyString, 16);
        KeyFactory keyfac = KeyFactory.getInstance(DH_ALGORITHM_NAME, "BC");
        PublicKey remotePubKey = keyfac.generatePublic(new DHPublicKeySpec(remoteY, params.getP(), params.getG()));
        this._keyAgreement.doPhase(remotePubKey, true);
    }

    private StringBuilder removeChar(StringBuilder sb, char c) {
        int index;
        while ((index = sb.indexOf("\n")) > -1) {
            sb.deleteCharAt(index);
        }
        return sb;
    }

    public byte[] decrypt(String cipherSpec, String keySpec, int blocksize, byte[] encrypted) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        byte[] iv = new byte[blocksize];
        Arrays.fill(iv, (byte)0);
        byte[] sharedSecret = this._keyAgreement.generateSecret();
        SecretKeySpec sessionKey = new SecretKeySpec(sharedSecret, 0, blocksize, keySpec);
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(cipherSpec, "BC");
        cipher.init(2, (Key)sessionKey, paramSpec);
        return cipher.doFinal(encrypted);
    }

    private String removeCharFromString(String s, char c) {
        return s.replaceAll(String.valueOf(c), "");
    }

    private DHParameterSpec fromDER(byte[] der) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(der);
        ASN1InputStream derInputStream = new ASN1InputStream((InputStream)inStream);
        DHParameter dhparam = new DHParameter((ASN1Sequence)derInputStream.readObject());
        return new DHParameterSpec(dhparam.getP(), dhparam.getG());
    }

    private byte[] toDER(DHParameterSpec paramspec) {
        DHParameter derParams = new DHParameter(paramspec.getP(), paramspec.getG(), paramspec.getP().bitLength());
        return derParams.getDEREncoded();
    }
}

