/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.InvalidHandlerConfigurationException;
import org.dcache.xrootd.plugins.authn.gsi.GSIAuthenticationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSIAuthenticationFactory
implements AuthenticationFactory {
    private static final Logger _logger = LoggerFactory.getLogger(GSIAuthenticationFactory.class);
    private final String _hostCertificatePath;
    private final String _hostKeyPath;
    private final String _caCertificatePath;
    private final X509CertChainValidator _validator;
    private final long _hostCertRefreshInterval;
    private final long _trustAnchorRefreshInterval;
    private long _hostCertRefreshTimestamp = 0L;
    private final boolean _verifyHostCertificate;
    private PEMCredential _hostCredential;

    public GSIAuthenticationFactory(Properties properties) {
        this._hostKeyPath = properties.getProperty("xrootd.gsi.hostcert.key");
        this._hostCertificatePath = properties.getProperty("xrootd.gsi.hostcert.cert");
        this._hostCertRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.hostcert.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.hostcert.refresh")));
        this._verifyHostCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.hostcert.verify"));
        this._caCertificatePath = properties.getProperty("xrootd.gsi.ca.path");
        this._trustAnchorRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.ca.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.ca.refresh")));
        NamespaceCheckingMode namespaceMode = NamespaceCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.namespace-mode"));
        CrlCheckingMode crlCheckingMode = CrlCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.crl-mode"));
        OCSPCheckingMode ocspCheckingMode = OCSPCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.ocsp-mode"));
        ValidatorParams validatorParams = new ValidatorParams(new RevocationParameters(crlCheckingMode, new OCSPParametes(ocspCheckingMode)), ProxySupport.ALLOW);
        this._validator = new OpensslCertChainValidator(this._caCertificatePath, false, namespaceMode, this._trustAnchorRefreshInterval, validatorParams, false);
    }

    public AuthenticationHandler createHandler() throws InvalidHandlerConfigurationException {
        try {
            this.loadServerCredentials();
        }
        catch (GeneralSecurityException gssex) {
            String msg = "Could not load certificates/key due to security error";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)gssex);
        }
        catch (IOException ioex) {
            String msg = "Could not read certificates/key from file-system";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)ioex);
        }
        return new GSIAuthenticationHandler((X509Credential)this._hostCredential, this._validator);
    }

    private synchronized void loadServerCredentials() throws CertificateException, KeyStoreException, IOException {
        long timeSinceLastServerRefresh = System.currentTimeMillis() - this._hostCertRefreshTimestamp;
        if (this._hostCredential == null || timeSinceLastServerRefresh >= this._hostCertRefreshInterval) {
            _logger.info("Time since last server cert refresh {}", (Object)timeSinceLastServerRefresh);
            _logger.info("Loading server certificates. Current refresh interval: {} ms", (Object)this._hostCertRefreshInterval);
            PEMCredential credential = new PEMCredential(this._hostKeyPath, this._hostCertificatePath, null);
            if (this._verifyHostCertificate) {
                _logger.info("Verifying host certificate");
                this._validator.validate(credential.getCertificateChain());
            }
            this._hostCredential = credential;
            this._hostCertRefreshTimestamp = System.currentTimeMillis();
        }
    }
}

