/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseGSIAuthenticationFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseGSIAuthenticationFactory.class);
    protected final String caCertificatePath;
    protected final X509CertChainValidator validator;
    protected final long trustAnchorRefreshInterval;

    protected BaseGSIAuthenticationFactory(Properties properties) {
        this.caCertificatePath = properties.getProperty("xrootd.gsi.ca.path");
        this.trustAnchorRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.ca.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.ca.refresh")));
        NamespaceCheckingMode namespaceMode = NamespaceCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.namespace-mode"));
        CrlCheckingMode crlCheckingMode = CrlCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.crl-mode"));
        OCSPCheckingMode ocspCheckingMode = OCSPCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.ocsp-mode"));
        ValidatorParams validatorParams = new ValidatorParams(new RevocationParameters(crlCheckingMode, new OCSPParametes(ocspCheckingMode)), ProxySupport.ALLOW);
        this.validator = new OpensslCertChainValidator(this.caCertificatePath, false, namespaceMode, this.trustAnchorRefreshInterval, validatorParams, false);
    }
}

