/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.InvalidHandlerConfigurationException;
import org.dcache.xrootd.plugins.authn.gsi.BaseGSIAuthenticationFactory;
import org.dcache.xrootd.plugins.authn.gsi.GSIAuthenticationHandler;

public class GSIAuthenticationFactory
extends BaseGSIAuthenticationFactory
implements AuthenticationFactory {
    private final String hostCertificatePath;
    private final String hostKeyPath;
    private final long hostCertRefreshInterval;
    private final boolean verifyHostCertificate;
    private PEMCredential hostCredential;
    private long hostCertRefreshTimestamp = 0L;

    public GSIAuthenticationFactory(Properties properties) {
        super(properties);
        this.hostKeyPath = properties.getProperty("xrootd.gsi.hostcert.key");
        this.hostCertificatePath = properties.getProperty("xrootd.gsi.hostcert.cert");
        this.hostCertRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.hostcert.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.hostcert.refresh")));
        this.verifyHostCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.hostcert.verify"));
    }

    public AuthenticationHandler createHandler() throws InvalidHandlerConfigurationException {
        try {
            this.loadServerCredentials();
        }
        catch (GeneralSecurityException gssex) {
            String msg = "Could not load certificates/key due to security error";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)gssex);
        }
        catch (IOException ioex) {
            String msg = "Could not read certificates/key from file-system";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)ioex);
        }
        return new GSIAuthenticationHandler((X509Credential)this.hostCredential, this.validator, this.caCertificatePath);
    }

    private synchronized void loadServerCredentials() throws CertificateException, KeyStoreException, IOException {
        if (this.shouldReloadServerCredentials()) {
            LOGGER.info("Loading server certificates. Current refresh interval: {} ms", (Object)this.hostCertRefreshInterval);
            PEMCredential credential = new PEMCredential(this.hostKeyPath, this.hostCertificatePath, null);
            if (this.verifyHostCertificate) {
                LOGGER.info("Verifying host certificate");
                this.validator.validate(credential.getCertificateChain());
            }
            this.hostCredential = credential;
            this.hostCertRefreshTimestamp = System.currentTimeMillis();
        }
    }

    private boolean shouldReloadServerCredentials() {
        long timeSinceLastServerRefresh = System.currentTimeMillis() - this.hostCertRefreshTimestamp;
        LOGGER.info("Time since last server cert refresh {}", (Object)timeSinceLastServerRefresh);
        return this.hostCredential == null || timeSinceLastServerRefresh >= this.hostCertRefreshInterval;
    }
}

