/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.HostnameToCertificateChecker;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.security.XrootdBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseGSIAuthenticationHandler {
    public static final String PROTOCOL = "gsi";
    public static final String PROTOCOL_VERSION = "10200";
    public static final String CRYPTO_MODE = "ssl";
    public static final String SUPPORTED_CIPHER_ALGORITHMS = "aes-128-cbc";
    public static final String SUPPORTED_DIGESTS = "sha1:md5";
    protected static final String SERVER_ASYNC_CIPHER_MODE = "RSA/NONE/PKCS1Padding";
    protected static final String SERVER_SYNC_CIPHER_MODE = "AES/CBC/PKCS5Padding";
    protected static final String SERVER_SYNC_CIPHER_NAME = "AES";
    protected static final int SERVER_SYNC_CIPHER_BLOCKSIZE = 16;
    protected static final int CHALLENGE_BYTES = 8;
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseGSIAuthenticationHandler.class);
    protected static final SecureRandom RANDOM = new SecureRandom();
    protected static final HostnameToCertificateChecker CERT_CHECKER = new HostnameToCertificateChecker();
    protected final X509Credential credential;
    protected final X509CertChainValidator validator;
    protected final File certDir;

    protected BaseGSIAuthenticationHandler(X509Credential credential, X509CertChainValidator validator, String certDir) {
        this.credential = credential;
        this.validator = validator;
        this.certDir = new File(certDir);
    }

    protected String generateChallengeString() {
        byte[] challengeBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            challengeBytes[i] = (byte)RANDOM.nextInt(127);
        }
        return new String(challengeBytes, StandardCharsets.US_ASCII);
    }

    protected void checkCaIdentities(String[] caIdentities) throws XrootdException {
        for (String ca : caIdentities) {
            if (this.isValidCaPath(ca)) continue;
            throw new XrootdException(4003, ca + " is not a valid ca cert path.");
        }
    }

    protected void checkVersion(String version) {
    }

    private boolean isValidCaPath(String path) {
        if ((path = path.trim()).indexOf(".") < 1) {
            path = path + ".0";
        }
        return new File(this.certDir, path).exists();
    }

    static class XrootdBucketContainer {
        private final int _size;
        private final List<XrootdBucket> _buckets;

        public XrootdBucketContainer(List<XrootdBucket> buckets, int size) {
            this._buckets = buckets;
            this._size = size;
        }

        public int getSize() {
            return this._size;
        }

        public List<XrootdBucket> getBuckets() {
            return this._buckets;
        }
    }
}

