/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.BaseGSIAuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.DHSession;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.AuthenticationResponse;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.NestedBucketBuffer;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.StringBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class GSIAuthenticationHandler
extends BaseGSIAuthenticationHandler
implements AuthenticationHandler {
    private final Subject subject = new Subject();
    private String challenge = "";
    private Cipher challengeCipher;
    private DHSession dhSession;
    private boolean finished = false;

    public GSIAuthenticationHandler(X509Credential hostCredential, X509CertChainValidator validator, String certDir) {
        super(hostCredential, validator, certDir);
    }

    public XrootdResponse<AuthenticationRequest> authenticate(AuthenticationRequest request) throws XrootdException {
        try {
            if (this.dhSession == null) {
                this.dhSession = new DHSession(true);
            }
        }
        catch (GeneralSecurityException gssex) {
            LOGGER.error("Error setting up cryptographic classes: {}", (Object)gssex.getMessage());
            throw new XrootdException(3012, "Server probably misconfigured.");
        }
        if (!"gsi".equalsIgnoreCase(request.getProtocol())) {
            throw new XrootdException(3006, "Specified Protocol " + request.getProtocol() + " is not the protocol that was negotiated.");
        }
        switch (request.getStep()) {
            case 0: {
                return new OkResponse((XrootdRequest)request);
            }
            case 1000: {
                return this.handleCertReqStep(request);
            }
            case 1001: {
                return this.handleCertStep(request);
            }
        }
        throw new XrootdException(3006, "Error during authentication, unknown processing step: " + request.getStep());
    }

    private XrootdResponse<AuthenticationRequest> handleCertReqStep(AuthenticationRequest request) throws XrootdException {
        try {
            this.challengeCipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
            this.challengeCipher.init(1, this.credential.getKey());
            Map buckets = request.getBuckets();
            NestedBucketBuffer buffer = (NestedBucketBuffer)buckets.get(XrootdSecurityProtocol.BucketType.kXRS_main);
            StringBucket rtagBucket = (StringBucket)buffer.getNestedBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_rtag);
            String rtag = rtagBucket.getContent();
            this.challengeCipher.update(rtag.getBytes());
            byte[] signedRtag = this.challengeCipher.doFinal();
            this.challenge = this.generateChallengeString();
            byte[] puk = this.dhSession.getEncodedDHMaterial().getBytes();
            this.credential.getCertificate().getEncoded();
            String hostCertificateString = CertUtil.certToPEM(this.credential.getCertificate());
            BaseGSIAuthenticationHandler.XrootdBucketContainer responseBuckets = this.buildCertReqResponse(signedRtag, this.challenge, "ssl", puk, "aes-128-cbc", "sha1:md5", hostCertificateString);
            return new AuthenticationResponse(request, 4002, responseBuckets.getSize(), "gsi", 2001, responseBuckets.getBuckets());
        }
        catch (InvalidKeyException ikex) {
            LOGGER.error("Configured host-key could not be used forsigning rtag: {}", (Object)ikex.getMessage());
            throw new XrootdException(3012, "Internal error occurred when trying to sign client authentication tag.");
        }
        catch (CertificateEncodingException cee) {
            LOGGER.error("Could not extract contents of server certificate: {}", (Object)cee.getMessage());
            throw new XrootdException(3012, "Internal error occurred when trying to send server certificate.");
        }
        catch (IOException | GeneralSecurityException gssex) {
            LOGGER.error("Problems during signing of client authN tag (algorithm {}): {}", (Object)"RSA/NONE/PKCS1Padding", (Object)(gssex.getMessage() == null ? gssex.getClass().getName() : gssex.getMessage()));
            throw new XrootdException(3012, "Internal error occurred when trying to sign client authentication tag.");
        }
    }

    private XrootdResponse<AuthenticationRequest> handleCertStep(AuthenticationRequest request) throws XrootdException {
        try {
            Map receivedBuckets = request.getBuckets();
            RawBucket encryptedBucket = (RawBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_main);
            byte[] encrypted = encryptedBucket.getContent();
            StringBucket dhMessage = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_puk);
            this.dhSession.finaliseKeyAgreement(dhMessage.getContent());
            byte[] decrypted = this.dhSession.decrypt("AES/CBC/PKCS5Padding", "AES", 16, encrypted);
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])decrypted);
            NestedBucketBuffer nestedBucket = NestedBucketBuffer.deserialize((XrootdSecurityProtocol.BucketType)XrootdSecurityProtocol.BucketType.kXRS_main, (ByteBuf)buffer);
            XrootdBucket clientX509Bucket = (XrootdBucket)nestedBucket.getNestedBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_x509);
            String clientX509 = ((StringBucket)clientX509Bucket).getContent();
            X509Certificate[] proxyCertChain = CertificateUtils.loadCertificateChain((InputStream)new ByteArrayInputStream(clientX509.getBytes(StandardCharsets.US_ASCII)), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            if (proxyCertChain.length == 0) {
                throw new IllegalArgumentException("Could not parse user certificate from input stream!");
            }
            X509Certificate proxyCert = proxyCertChain[0];
            LOGGER.info("The proxy-cert has the subject {} and the issuer {}", (Object)proxyCert.getSubjectDN(), (Object)proxyCert.getIssuerDN());
            this.validator.validate(proxyCertChain);
            this.subject.getPublicCredentials().add(proxyCertChain);
            this.challengeCipher.init(2, proxyCert.getPublicKey());
            XrootdBucket signedRTagBucket = (XrootdBucket)nestedBucket.getNestedBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag);
            byte[] signedRTag = ((RawBucket)signedRTagBucket).getContent();
            byte[] rTag = this.challengeCipher.doFinal(signedRTag);
            String rTagString = new String(rTag, StandardCharsets.US_ASCII);
            if (!this.challenge.equals(rTagString)) {
                LOGGER.error("The challenge is {}, the serialized rTag is {}.signature of challenge tag has been proven wrong!!", (Object)this.challenge, (Object)rTagString);
                throw new XrootdException(3006, "Client did not present correctchallenge response!");
            }
            LOGGER.trace("signature of challenge tag ok. Challenge: {}, rTagString: {}", (Object)this.challenge, (Object)rTagString);
            this.finished = true;
            return new OkResponse((XrootdRequest)request);
        }
        catch (InvalidKeyException ikex) {
            LOGGER.error("The key negotiated by DH key exchange appears to be invalid: {}", (Object)ikex.getMessage());
            throw new XrootdException(3006, "Could not decrypt clientinformation with negotiated key.");
        }
        catch (InvalidKeySpecException iksex) {
            LOGGER.error("DH key negotiation caused problems {}", (Object)iksex.getMessage());
            throw new XrootdException(3006, "Could not find key negotiation parameters.");
        }
        catch (IOException ioex) {
            LOGGER.error("Could not deserialize main nested buffer {}", (Object)(ioex.getMessage() == null ? ioex.getClass().getName() : ioex.getMessage()));
            throw new XrootdException(3007, "Could not decrypt encrypted client message.");
        }
        catch (GeneralSecurityException gssex) {
            LOGGER.error("Error during decrypting/server-side key exchange: {}", (Object)gssex.getMessage());
            throw new XrootdException(3012, "Error in server-side cryptographic operations.");
        }
    }

    private BaseGSIAuthenticationHandler.XrootdBucketContainer buildCertReqResponse(byte[] signedChallenge, String newChallenge, String cryptoMode, byte[] puk, String supportedCiphers, String supportedDigests, String hostCertificate) {
        int responseLength = 0;
        ArrayList<XrootdBucket> responseList = new ArrayList<XrootdBucket>();
        RawBucket signedRtagBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag, signedChallenge);
        StringBucket randomTagBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_rtag, newChallenge);
        EnumMap<XrootdSecurityProtocol.BucketType, Object> nestedBuckets = new EnumMap<XrootdSecurityProtocol.BucketType, Object>(XrootdSecurityProtocol.BucketType.class);
        nestedBuckets.put(signedRtagBucket.getType(), (Object)signedRtagBucket);
        nestedBuckets.put(randomTagBucket.getType(), (Object)randomTagBucket);
        NestedBucketBuffer mainBucket = new NestedBucketBuffer(XrootdSecurityProtocol.BucketType.kXRS_main, "gsi", 2001, nestedBuckets);
        StringBucket cryptoBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cryptomod, "ssl");
        responseLength += cryptoBucket.getSize();
        responseList.add((XrootdBucket)cryptoBucket);
        responseLength += mainBucket.getSize();
        responseList.add((XrootdBucket)mainBucket);
        RawBucket dhPublicBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_puk, puk);
        responseLength += dhPublicBucket.getSize();
        responseList.add((XrootdBucket)dhPublicBucket);
        StringBucket cipherBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg, supportedCiphers);
        responseLength += cipherBucket.getSize();
        responseList.add((XrootdBucket)cipherBucket);
        StringBucket digestBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_md_alg, supportedDigests);
        responseLength += digestBucket.getSize();
        responseList.add((XrootdBucket)digestBucket);
        StringBucket hostCertBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_x509, hostCertificate);
        responseList.add((XrootdBucket)hostCertBucket);
        return new BaseGSIAuthenticationHandler.XrootdBucketContainer(responseList, responseLength += hostCertBucket.getSize());
    }

    public String getProtocol() {
        String subjectHash = CertUtil.computeMD5Hash(this.credential.getCertificate().getIssuerX500Principal());
        return "&P=gsi,v:10200,c:ssl,ca:" + subjectHash;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean isCompleted() {
        return this.finished;
    }
}

