/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.authn.gsi.BaseGSIAuthenticationFactory;
import org.dcache.xrootd.plugins.authn.gsi.GSIClientAuthenticationHandler;

public class GSIClientAuthenticationFactory
extends BaseGSIAuthenticationFactory
implements ChannelHandlerFactory {
    private final String clientCertificatePath;
    private final String clientKeyPath;
    private final long proxyRefreshInterval;
    private final boolean verifyClientCertificate;
    private PEMCredential clientCredential;
    private long proxyRefreshTimestamp = 0L;
    private String clientCredIssuerHashes;
    private String proxyPath;
    private X509Credential proxy;

    public GSIClientAuthenticationFactory(Properties properties) {
        super(properties);
        this.clientKeyPath = properties.getProperty("xrootd.gsi.tpc.cred.key");
        this.clientCertificatePath = properties.getProperty("xrootd.gsi.tpc.cred.cert");
        this.proxyRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.tpc.cred.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.tpc.cred.refresh")));
        this.verifyClientCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.tpc.cred.verify"));
        this.proxyPath = properties.getProperty("xrootd.gsi.tpc.proxy.path");
    }

    public ChannelHandler createHandler() {
        this.loadClientCredentials();
        GSIClientAuthenticationHandler handler = new GSIClientAuthenticationHandler(this.proxy, this.validator, this.caCertificatePath, this.clientCredIssuerHashes);
        return handler;
    }

    public String getDescription() {
        return "GSI authentication client plugin for third-party transfers";
    }

    public String getName() {
        return "gsi";
    }

    private synchronized void loadClientCredentials() {
        block8: {
            try {
                if (!this.shouldRefreshClientProxyCredential()) break block8;
                LOGGER.info("Refreshing proxy credential. Current refresh interval: {} ms", (Object)this.proxyRefreshInterval);
                if (!Strings.isNullOrEmpty((String)this.proxyPath)) {
                    this.proxy = new PEMCredential(this.proxyPath, (char[])null);
                } else {
                    this.clientCredential = new PEMCredential(this.clientKeyPath, this.clientCertificatePath, null);
                    if (this.verifyClientCertificate) {
                        LOGGER.info("Verifying client certificate");
                        this.validator.validate(this.clientCredential.getCertificateChain());
                    }
                    try {
                        ProxyCertificateOptions options = new ProxyCertificateOptions(this.clientCredential.getCertificateChain());
                        ProxyCertificate proxyCert = ProxyGenerator.generate((ProxyCertificateOptions)options, (PrivateKey)this.clientCredential.getKey());
                        this.proxy = proxyCert.getCredential();
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                        throw new CertificateException("could not generate host proxy credential.", e);
                    }
                }
                this.proxyRefreshTimestamp = System.currentTimeMillis();
            }
            catch (GeneralSecurityException gssex) {
                LOGGER.error("Could not load certificates/key due to security error; {}: {}.", (Object)this.getCredentialValues(), (Object)gssex.toString());
            }
            catch (IOException ioex) {
                LOGGER.error("Could not read certificates/key from file-system; {}: {}.", (Object)this.getCredentialValues(), (Object)ioex.toString());
            }
        }
        this.clientCredIssuerHashes = this.getClientCredIssuerHashes();
    }

    private String getClientCredIssuerHashes() {
        HashSet<String> issuers = new HashSet<String>();
        for (X509Certificate certificate : this.proxy.getCertificateChain()) {
            X500Principal certIssuer = certificate.getIssuerX500Principal();
            issuers.add(OpensslTruststoreHelper.getOpenSSLCAHash((X500Principal)certIssuer, (boolean)true));
        }
        return Joiner.on((String)"|").join(issuers);
    }

    private String getCredentialValues() {
        return "client cert path: " + this.clientCertificatePath + ", client key path: " + this.clientKeyPath + ", client issuer hashes: " + this.clientCredIssuerHashes + ", proxy path: " + this.proxyPath;
    }

    private boolean shouldRefreshClientProxyCredential() {
        long timeSinceLastClientRefresh = System.currentTimeMillis() - this.proxyRefreshTimestamp;
        LOGGER.info("Time since last client cert refresh {}", (Object)timeSinceLastClientRefresh);
        return this.proxy == null || timeSinceLastClientRefresh >= this.proxyRefreshInterval;
    }
}

