/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.BaseGSIAuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.DHEncrypter;
import org.dcache.xrootd.plugins.authn.gsi.DHSession;
import org.dcache.xrootd.plugins.authn.gsi.GSISigverRequestHandler;
import org.dcache.xrootd.security.NestedBucketBuffer;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.SecurityInfo;
import org.dcache.xrootd.security.StringBucket;
import org.dcache.xrootd.security.UnsignedIntBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.dcache.xrootd.tpc.AbstractClientRequestHandler;
import org.dcache.xrootd.tpc.TpcSigverRequestHandler;
import org.dcache.xrootd.tpc.XrootdTpcClient;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdInboundResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAttnResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundLoginResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundAuthenticationRequest;

public class GSIClientAuthenticationHandler
extends AbstractClientRequestHandler {
    private BaseGSIAuthenticationHandler handler;
    private String issuerHashes;
    private InboundLoginResponse loginResponse;

    static BaseGSIAuthenticationHandler.XrootdBucketContainer build(XrootdBucket ... buckets) {
        int responseLength = 0;
        ArrayList<XrootdBucket> responseList = new ArrayList<XrootdBucket>();
        for (XrootdBucket bucket : buckets) {
            responseList.add(bucket);
            responseLength += bucket.getSize();
        }
        return new BaseGSIAuthenticationHandler.XrootdBucketContainer(responseList, responseLength);
    }

    public GSIClientAuthenticationHandler(X509Credential proxyCredential, X509CertChainValidator validator, String certDir, String issuerHashes) {
        this.handler = new BaseGSIAuthenticationHandler(proxyCredential, validator, certDir);
        this.issuerHashes = issuerHashes;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable t) {
        if (t instanceof RuntimeException) {
            super.exceptionCaught(ctx, t);
            return;
        }
        LOGGER.error("Unable to complete GSI authentication to {}, channel {}, stream {}, session {}: {}.", new Object[]{this.client.getInfo().getSrc(), ctx.channel().id(), this.client.getStreamId(), this.client.getSessionId(), t.toString()});
        try {
            super.doOnLoginResponse(ctx, this.loginResponse);
        }
        catch (XrootdException e) {
            super.exceptionCaught(ctx, (Throwable)e);
        }
    }

    protected void doOnAsynResponse(ChannelHandlerContext ctx, InboundAttnResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3000: {
                this.sendAuthenticationRequest(ctx);
                break;
            }
            default: {
                super.doOnAsynResponse(ctx, response);
            }
        }
    }

    protected void doOnAuthenticationResponse(ChannelHandlerContext ctx, InboundAuthenticationResponse response) throws XrootdException {
        ChannelId id = ctx.channel().id();
        int status = response.getStatus();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        switch (status) {
            case 0: {
                LOGGER.trace("Authentication to {}, channel {}, stream {}, sessionId {} succeeded; passing to next handler.", new Object[]{tpcInfo.getSrc(), id, streamId, this.client.getSessionId()});
                ctx.fireChannelRead((Object)response);
                break;
            }
            case 4002: {
                LOGGER.trace("Authentication to {}, channel {}, stream {}, sessionId {}, proceeding to next step.", new Object[]{tpcInfo.getSrc(), id, streamId, this.client.getSessionId()});
                this.client.setAuthResponse(response);
                this.sendAuthenticationRequest(ctx);
                break;
            }
            default: {
                throw new XrootdException(3012, "wrong status from authentication response: " + status);
            }
        }
    }

    protected void doOnLoginResponse(ChannelHandlerContext ctx, InboundLoginResponse response) throws XrootdException {
        ChannelId id = ctx.channel().id();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        SecurityInfo gsiSec = response.getInfo("gsi");
        if (gsiSec == null) {
            String error = String.format("login to %s, channel %s, stream %s, session %s, GSI handler was added to pipeline, but the GSI protocol was notindicated by the server; this is a bug; please report to support@dcache.org.", tpcInfo.getSrc(), id, streamId, this.client.getSessionId());
            throw new RuntimeException(error);
        }
        this.loginResponse = response;
        this.client.getAuthnContext().put("protocol", gsiSec.getProtocol());
        this.client.getAuthnContext().put("version", gsiSec.getVersion());
        this.client.getAuthnContext().put("encryption", gsiSec.getEncryption());
        this.client.getAuthnContext().put("caIdentities", gsiSec.getCaIdentities());
        this.sendAuthenticationRequest(ctx);
    }

    protected void doOnWaitResponse(ChannelHandlerContext ctx, AbstractXrootdInboundResponse response) throws XrootdException {
        switch (response.getRequestId()) {
            case 3000: {
                this.client.getExecutor().schedule(() -> {
                    try {
                        this.sendAuthenticationRequest(ctx);
                    }
                    catch (XrootdException e) {
                        this.exceptionCaught(ctx, e);
                    }
                }, (long)this.getWaitInSeconds(response), TimeUnit.SECONDS);
                break;
            }
            default: {
                super.doOnWaitResponse(ctx, response);
            }
        }
    }

    protected void sendAuthenticationRequest(ChannelHandlerContext ctx) throws XrootdException {
        OutboundAuthenticationRequest request;
        ChannelId id = ctx.channel().id();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        InboundAuthenticationResponse previous = this.client.getAuthResponse();
        if (previous != null) {
            request = this.handleCertStep(previous, ctx);
            LOGGER.trace("sendAuthenticationRequest to {}, channel {}, stream {}, step: cert.", new Object[]{tpcInfo.getSrc(), id, streamId});
        } else {
            request = this.handleCertReqStep();
            LOGGER.trace("sendAuthenticationRequest to {}, channel {}, stream {}, step: cert request.", new Object[]{tpcInfo.getSrc(), id, streamId});
        }
        this.client.setExpectedResponse(3000);
        this.client.setAuthResponse(null);
        ctx.writeAndFlush((Object)request, ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    private OutboundAuthenticationRequest handleCertReqStep() throws XrootdException {
        String encryption = (String)this.client.getAuthnContext().get("encryption");
        if (!encryption.equalsIgnoreCase("ssl")) {
            throw new XrootdException(4003, "handler does not support " + encryption);
        }
        String[] caIdentities = (String[])this.client.getAuthnContext().get("caIdentities");
        this.handler.checkCaIdentities(caIdentities);
        String version = (String)this.client.getAuthnContext().get("version");
        this.handler.checkVersion(version);
        String rtag = this.handler.generateChallengeString();
        this.client.getAuthnContext().put("rtag", rtag);
        BaseGSIAuthenticationHandler.XrootdBucketContainer container = new OutboundRequestBuckets(rtag).buildContainer();
        return new OutboundAuthenticationRequest(this.client.getStreamId(), container.getSize(), "gsi", 1000, container.getBuckets());
    }

    private OutboundAuthenticationRequest handleCertStep(InboundAuthenticationResponse response, ChannelHandlerContext ctx) throws XrootdException {
        try {
            InboundResponseBuckets inbound = new InboundResponseBuckets(response, this.client);
            inbound.validateCiphers();
            inbound.validateDigests();
            inbound.validateCertificate();
            inbound.validateSignedChallenge();
            inbound.signChallenge();
            inbound.encodeHostCerts();
            inbound.finalizeDHSessionKey();
            DHEncrypter encrypter = new DHEncrypter(inbound.session, "AES/CBC/PKCS5Padding", "AES", 16);
            GSISigverRequestHandler sigverRequestHandler = new GSISigverRequestHandler(encrypter, this.client);
            this.client.setSigverRequestHandler((TpcSigverRequestHandler)sigverRequestHandler);
            BaseGSIAuthenticationHandler.XrootdBucketContainer container = new OutboundResponseBuckets(inbound, ctx).buildContainer();
            return new OutboundAuthenticationRequest(response.getStreamId(), container.getSize(), "gsi", 1001, container.getBuckets());
        }
        catch (IOException e) {
            LOGGER.error("Problems during cert step {}." + e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            throw new XrootdException(3012, "Internal error occurred during cert step.");
        }
        catch (InvalidKeyException e) {
            LOGGER.error("The key negotiated by DH key exchange appears to be invalid: {}", (Object)e.getMessage());
            throw new XrootdException(3006, "Could not decrypt server information with negotiated key.");
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Cryptographic issues encountered during cert step: {}", (Object)e.getMessage());
            throw new XrootdException(3012, "Could not complete cert step: an error occurred during cryptographic operations.");
        }
    }

    class OutboundResponseBuckets
    implements BucketContainerBuilder {
        RawBucket encryptedBucket;
        RawBucket pukBucket;
        StringBucket cipherBucket;
        StringBucket digestBucket;

        OutboundResponseBuckets(InboundResponseBuckets buckets, ChannelHandlerContext ctx) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeyException {
            this.pukBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_puk, buckets.puk);
            this.cipherBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg, buckets.selectedCipher);
            this.digestBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_md_alg, buckets.selectedDigest);
            StringBucket x509Bucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_x509, buckets.hostProxyCert);
            RawBucket signedTagBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag, buckets.signedChallenge);
            ByteBuf buffer = ctx.alloc().buffer();
            byte[] bytes = "gsi".getBytes(StandardCharsets.US_ASCII);
            buffer.writeBytes(bytes);
            buffer.writeZero(4 - bytes.length);
            buffer.writeInt(1001);
            signedTagBucket.serialize(buffer);
            x509Bucket.serialize(buffer);
            buffer.writeInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
            byte[] raw = new byte[buffer.readableBytes()];
            buffer.getBytes(0, raw);
            buffer.release();
            byte[] encrypted = buckets.session.encrypt("AES/CBC/PKCS5Padding", "AES", 16, raw);
            this.encryptedBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_main, encrypted);
        }

        @Override
        public BaseGSIAuthenticationHandler.XrootdBucketContainer buildContainer() {
            return GSIClientAuthenticationHandler.build(new XrootdBucket[]{this.encryptedBucket, this.cipherBucket, this.digestBucket, this.pukBucket});
        }
    }

    class OutboundRequestBuckets
    implements BucketContainerBuilder {
        private StringBucket cryptoBucket;
        private UnsignedIntBucket versionBucket;
        private StringBucket issuerBucket;
        private NestedBucketBuffer mainBucket;

        OutboundRequestBuckets(String rtag) throws XrootdException {
            EnumMap<XrootdSecurityProtocol.BucketType, StringBucket> nestedBuckets = new EnumMap<XrootdSecurityProtocol.BucketType, StringBucket>(XrootdSecurityProtocol.BucketType.class);
            StringBucket randomTagBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_rtag, rtag);
            nestedBuckets.put(randomTagBucket.getType(), randomTagBucket);
            this.mainBucket = new NestedBucketBuffer(XrootdSecurityProtocol.BucketType.kXRS_main, "gsi", 1000, nestedBuckets);
            this.cryptoBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cryptomod, "ssl");
            this.versionBucket = new UnsignedIntBucket(XrootdSecurityProtocol.BucketType.kXRS_version, 10200);
            this.issuerBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_issuer_hash, GSIClientAuthenticationHandler.this.issuerHashes);
        }

        @Override
        public BaseGSIAuthenticationHandler.XrootdBucketContainer buildContainer() {
            return GSIClientAuthenticationHandler.build(new XrootdBucket[]{this.cryptoBucket, this.versionBucket, this.issuerBucket, this.mainBucket});
        }
    }

    class InboundResponseBuckets {
        private String srcHost;
        private byte[] signedChallenge;
        private byte[] puk;
        private String hostProxyCert;
        private String selectedCipher;
        private String selectedDigest;
        private RawBucket signedRTagBucket;
        private StringBucket randomTagBucket;
        private StringBucket dhPublicBucket;
        private StringBucket cipherBucket;
        private StringBucket digestBucket;
        private StringBucket serverX509Bucket;
        private X509Certificate serverCert;
        private DHSession session;
        private String rtag;
        private Cipher challengeCipher;

        InboundResponseBuckets(InboundAuthenticationResponse response, XrootdTpcClient client) throws GeneralSecurityException {
            this.srcHost = client.getInfo().getSrcHost();
            this.rtag = (String)client.getAuthnContext().get("rtag");
            if (!response.getProtocol().equals("gsi")) {
                throw new GeneralSecurityException("server replied with incorrect protocol: " + response.getProtocol());
            }
            if (response.getServerStep() != 2001) {
                throw new GeneralSecurityException("server replied with incorrect step: " + response.getServerStep());
            }
            Map receivedBuckets = response.getBuckets();
            this.dhPublicBucket = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_puk);
            this.cipherBucket = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg);
            this.digestBucket = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_md_alg);
            this.serverX509Bucket = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_x509);
            this.signedRTagBucket = (RawBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag);
            this.randomTagBucket = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_rtag);
        }

        void finalizeDHSessionKey() throws IOException, GeneralSecurityException, XrootdException {
            this.session = new DHSession(false);
            this.session.finaliseKeyAgreement(this.dhPublicBucket.getContent());
            this.puk = this.session.getEncodedDHMaterial().getBytes();
        }

        void encodeHostCerts() throws CertificateEncodingException {
            X509Certificate[] chain;
            StringBuilder builder = new StringBuilder();
            for (X509Certificate cert : chain = ((GSIClientAuthenticationHandler)GSIClientAuthenticationHandler.this).handler.credential.getCertificateChain()) {
                cert.getEncoded();
                builder.append(CertUtil.certToPEM(cert));
            }
            this.hostProxyCert = builder.toString();
        }

        void signChallenge() throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException {
            this.challengeCipher.init(1, ((GSIClientAuthenticationHandler)GSIClientAuthenticationHandler.this).handler.credential.getKey());
            String serverRtag = this.randomTagBucket.getContent();
            this.challengeCipher.update(serverRtag.getBytes());
            this.signedChallenge = this.challengeCipher.doFinal();
        }

        void validateCertificate() throws IOException, GeneralSecurityException {
            byte[] clientX509 = this.serverX509Bucket.getContent().getBytes(StandardCharsets.US_ASCII);
            X509Certificate[] proxyCertChain = CertificateUtils.loadCertificateChain((InputStream)new ByteArrayInputStream(clientX509), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            if (proxyCertChain.length == 0) {
                String error = "Could not parse server certificate from input stream!";
                throw new GeneralSecurityException(error);
            }
            this.serverCert = proxyCertChain[0];
            ((GSIClientAuthenticationHandler)GSIClientAuthenticationHandler.this).handler.validator.validate(proxyCertChain);
            if (this.serverCert.getSubjectDN().getName().contains(this.srcHost) || BaseGSIAuthenticationHandler.CERT_CHECKER.checkMatching(this.srcHost, this.serverCert)) {
                return;
            }
            String error = "The name of the source server does not match any subject name of the received credential.";
            throw new GeneralSecurityException(error);
        }

        void validateCiphers() throws XrootdException {
            String[] algorithms;
            for (String algorithm : algorithms = this.cipherBucket.getContent().split("[:]")) {
                if (!"aes-128-cbc".contains(algorithm)) continue;
                this.selectedCipher = algorithm;
                break;
            }
            if (this.selectedCipher == null) {
                throw new XrootdException(4003, "all server ciphers are unsupported: " + this.cipherBucket.getContent());
            }
        }

        void validateDigests() throws XrootdException {
            String[] digests;
            for (String digest : digests = this.digestBucket.getContent().split("[:]")) {
                if (!"sha1:md5".contains(digest)) continue;
                this.selectedDigest = digest;
                break;
            }
            if (this.selectedDigest == null) {
                throw new XrootdException(4003, "all server digests are unsupported: " + this.digestBucket.getContent());
            }
        }

        void validateSignedChallenge() throws XrootdException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, BadPaddingException, IllegalBlockSizeException {
            this.challengeCipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
            this.challengeCipher.init(2, this.serverCert.getPublicKey());
            byte[] signedRTag = this.signedRTagBucket.getContent();
            byte[] rTag = this.challengeCipher.doFinal(signedRTag);
            String rTagString = new String(rTag, StandardCharsets.US_ASCII);
            if (!this.rtag.equals(rTagString)) {
                LOGGER.error("The challenge is {}, the serialized rTag is {}.signature of challenge tag has been proven wrong!!", (Object)this.rtag, (Object)rTagString);
                throw new XrootdException(3006, "Client did not present correct challenge response!");
            }
            LOGGER.trace("signature of challenge tag ok. Challenge: {}, rTagString: {}", (Object)this.rtag, (Object)rTagString);
        }
    }

    static interface BucketContainerBuilder {
        public BaseGSIAuthenticationHandler.XrootdBucketContainer buildContainer();
    }
}

