/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.trust;

import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.trust.TimedTrustAnchorStoreBase;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;

public class JDKInMemoryTrustAnchorStore
extends TimedTrustAnchorStoreBase {
    protected KeyStore keystore;
    protected Set<TrustAnchor> anchors;
    protected X509Certificate[] ca;

    public JDKInMemoryTrustAnchorStore(KeyStore ks) throws KeyStoreException {
        this(ks, null, -1L, new ObserversHandler());
    }

    protected JDKInMemoryTrustAnchorStore(KeyStore ks, Timer timer, long updateInterval, ObserversHandler observers) throws KeyStoreException {
        super(timer, updateInterval, observers);
        this.keystore = ks;
        this.anchors = new HashSet<TrustAnchor>();
        this.load();
    }

    protected void load() throws KeyStoreException {
        Enumeration<String> aliases = this.keystore.aliases();
        this.anchors.clear();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate x509Cert = null;
            if (this.keystore.isCertificateEntry(alias)) {
                Certificate cert = this.keystore.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                x509Cert = (X509Certificate)cert;
            } else {
                Certificate[] certs;
                if (!this.keystore.isKeyEntry(alias) || !((certs = this.keystore.getCertificateChain(alias))[0] instanceof X509Certificate)) continue;
                x509Cert = (X509Certificate)certs[0];
            }
            this.checkValidity("Unknown location (certificate retrieved from keystore)", x509Cert, true);
            this.anchors.add(new TrustAnchor(x509Cert, null));
        }
        this.ca = new X509Certificate[this.anchors.size()];
        int i = 0;
        for (TrustAnchor anchor : this.anchors) {
            this.ca[i++] = anchor.getTrustedCert();
        }
    }

    @Override
    public Set<TrustAnchor> getTrustAnchors() {
        HashSet<TrustAnchor> ret = new HashSet<TrustAnchor>();
        ret.addAll(this.anchors);
        return ret;
    }

    @Override
    public X509Certificate[] getTrustedCertificates() {
        return Arrays.copyOf(this.ca, this.ca.length);
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    @Override
    protected void update() {
    }
}

