/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import io.netty.channel.ChannelHandlerContext;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.DHEncrypter;
import org.dcache.xrootd.security.BufferEncrypter;
import org.dcache.xrootd.tpc.TpcSigverRequestHandler;
import org.dcache.xrootd.tpc.XrootdTpcClient;
import org.dcache.xrootd.tpc.protocol.messages.AbstractXrootdOutboundRequest;
import org.dcache.xrootd.tpc.protocol.messages.OutboundSigverRequest;
import org.dcache.xrootd.tpc.protocol.messages.XrootdOutboundRequest;

public class GSISigverRequestHandler
extends TpcSigverRequestHandler<DHEncrypter> {
    private long seqno = 0L;

    public GSISigverRequestHandler(DHEncrypter encrypter, XrootdTpcClient client) {
        super((BufferEncrypter)encrypter, client);
    }

    public OutboundSigverRequest createSigverRequest(ChannelHandlerContext ctx, XrootdOutboundRequest request) throws XrootdException {
        if (!(request instanceof AbstractXrootdOutboundRequest)) {
            return null;
        }
        AbstractXrootdOutboundRequest abstractRequest = (AbstractXrootdOutboundRequest)request;
        Map overrides = this.client.getOverrides();
        Integer override = (Integer)overrides.get(abstractRequest.getRequestId());
        if (!abstractRequest.isSigned(this.client.getSeclvl(), override == null ? 0 : override)) {
            return null;
        }
        ++this.seqno;
        try {
            OutboundSigverRequest sigverRequest = new OutboundSigverRequest(this.seqno, abstractRequest, ctx);
            if (this.encrypter != null) {
                sigverRequest.encrypt(this.encrypter);
            }
            return sigverRequest;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new XrootdException(3012, e.getMessage());
        }
    }
}

