/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ssl;

import eu.emi.security.authn.x509.X509Credential;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class CredentialX509KeyManager
extends X509ExtendedKeyManager {
    private X509Credential credential;

    public CredentialX509KeyManager(X509Credential credential) {
        this.credential = credential;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.credential.getKeyAlias();
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.credential.getKeyAlias();
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.credential.getCertificateChain();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return new String[]{this.credential.getKeyAlias()};
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.credential.getKey();
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[]{this.credential.getKeyAlias()};
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.credential.getKeyAlias();
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.credential.getKeyAlias();
    }
}

