/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.InvalidHandlerConfigurationException;
import org.dcache.xrootd.plugins.ProxyDelegationClient;
import org.dcache.xrootd.plugins.authn.gsi.GSIAuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;

public class GSIAuthenticationFactory
implements AuthenticationFactory {
    private final Properties properties;

    public GSIAuthenticationFactory(Properties properties) {
        this.properties = properties;
    }

    public AuthenticationHandler createHandler(ProxyDelegationClient proxyDelegationClient) throws InvalidHandlerConfigurationException {
        GSICredentialManager credentialManager = new GSICredentialManager(this.properties);
        credentialManager.setProxyDelegationClient(proxyDelegationClient);
        try {
            credentialManager.loadServerCredentials();
        }
        catch (GeneralSecurityException gssex) {
            String msg = "Could not load certificates/key due to security error";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)gssex);
        }
        catch (IOException ioex) {
            String msg = "Could not read certificates/key from file-system";
            throw new InvalidHandlerConfigurationException(msg, (Throwable)ioex);
        }
        return new GSIAuthenticationHandler(credentialManager);
    }
}

