/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.X509Credential;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Optional;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.DHSession;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainer;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainerBuilder;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.GSIRequestHandler;
import org.dcache.xrootd.security.BufferEncrypter;
import org.dcache.xrootd.security.NestedBucketBuffer;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.security.StringBucket;
import org.dcache.xrootd.security.UnsignedIntBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.dcache.xrootd.tpc.TpcSigverRequestEncoder;
import org.dcache.xrootd.tpc.XrootdTpcClient;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundAuthenticationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GSIClientRequestHandler
extends GSIRequestHandler {
    protected static Logger LOGGER = LoggerFactory.getLogger(GSIClientRequestHandler.class);
    protected final XrootdTpcClient client;

    protected GSIClientRequestHandler(GSICredentialManager credentialManager, XrootdTpcClient client) {
        super(credentialManager);
        this.client = client;
    }

    public OutboundAuthenticationRequest handleCertReqStep() throws XrootdException {
        this.loadClientCredential();
        this.validateCryptoMode(((Optional)this.client.getAuthnContext().get("encryption")).orElse(""));
        String caIdentities = ((Optional)this.client.getAuthnContext().get("caIdentities")).orElse("");
        this.credentialManager.checkCaIdentities(caIdentities.split("[|]"));
        this.challenge = GSIRequestHandler.generateChallengeString();
        GSIBucketContainer container = new CertRequestBuckets(this.challenge, this.getClientOpts()).buildContainer();
        return new OutboundAuthenticationRequest(this.client.getStreamId(), container.getSize(), "gsi", 1000, container.getBuckets());
    }

    public abstract OutboundAuthenticationRequest handleCertStep(InboundAuthenticationResponse var1, ChannelHandlerContext var2) throws XrootdException;

    protected Optional<TpcSigverRequestEncoder> getSigverEncoder(XrootdTpcClient client) {
        SigningPolicy signingPolicy = client.getSigningPolicy();
        LOGGER.debug("Getting (optional) signed hash verification encoder, signing is on? {}.", (Object)signingPolicy.isSigningOn());
        TpcSigverRequestEncoder sigverRequestEncoder = null;
        if (signingPolicy.isSigningOn()) {
            sigverRequestEncoder = new TpcSigverRequestEncoder((BufferEncrypter)this.bufferHandler, signingPolicy);
        }
        return Optional.ofNullable(sigverRequestEncoder);
    }

    protected X509Certificate validateCertificate(InboundAuthenticationResponse inbound) throws IOException, GeneralSecurityException, XrootdException {
        X509Certificate[] chain = this.processRSAVerification(inbound.getBuckets(), Optional.empty());
        X509Certificate serverCert = chain[0];
        GSICredentialManager.checkIdentity(serverCert, this.client.getInfo().getSrcHost());
        return serverCert;
    }

    protected String validateCiphers(InboundAuthenticationResponse inbound) throws XrootdException {
        StringBucket cipherBucket = (StringBucket)inbound.getBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg);
        return this.validateCiphers(cipherBucket.getContent().split("[:]"));
    }

    protected String validateDigests(InboundAuthenticationResponse inbound) throws XrootdException {
        StringBucket digestBucket = (StringBucket)inbound.getBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_md_alg);
        return this.validateDigests(digestBucket.getContent().split("[:]"));
    }

    protected OutboundAuthenticationRequest handleCertStep(InboundAuthenticationResponse response, ChannelHandlerContext ctx, XrootdSecurityProtocol.BucketType dhParamBucket, boolean signDhParams, Optional<String> publicKeyPem, Optional<String> userName) throws XrootdException {
        try {
            String selectedCipher = this.validateCiphers(response);
            String selectedDigest = this.validateDigests(response);
            X509Certificate serverCert = this.validateCertificate(response);
            this.rsaSession.initializeForDecryption(serverCert.getPublicKey());
            this.verifySignedRTag(response.getBuckets());
            this.dhSession = new DHSession(false, GSIClientRequestHandler.findSessionIVLen(selectedCipher));
            this.dhSession.setPaddedKey(this.usePadded());
            this.finalizeSessionKey(response.getBuckets(), dhParamBucket);
            Optional<TpcSigverRequestEncoder> encoder = this.getSigverEncoder(this.client);
            if (encoder.isPresent()) {
                ctx.pipeline().addAfter("encoder", "sigverEncoder", (ChannelHandler)encoder.get());
            }
            X509Credential clientCredential = this.getClientCredential();
            X509Certificate[] chain = clientCredential.getCertificateChain();
            String serializedCert = CertUtil.chainToPEM(Arrays.asList(chain));
            this.rsaSession.initializeForEncryption(clientCredential.getKey());
            XrootdBucket mainBucket = this.postProcessMainBucket(response.getBuckets(), Optional.of(serializedCert), 1001);
            GSIBucketContainer container = new CertResponseBuckets(mainBucket, this.dhParams(signDhParams), dhParamBucket, publicKeyPem, userName, selectedCipher, selectedDigest).buildContainer();
            return new OutboundAuthenticationRequest(response.getStreamId(), container.getSize(), "gsi", 1001, container.getBuckets());
        }
        catch (IOException e) {
            LOGGER.error("Problems during cert step {}." + e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            throw new XrootdException(3012, "Internal error occurred during cert step.");
        }
        catch (InvalidKeyException e) {
            LOGGER.error("The key negotiated by DH key exchange appears to be invalid: {}", (Object)e.getMessage());
            throw new XrootdException(3006, "Could not decrypt server information with negotiated key.");
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Cryptographic issues encountered during cert step: {}", (Object)e.getMessage());
            throw new XrootdException(3012, "Could not complete cert step: an error occurred during cryptographic operations.");
        }
    }

    protected abstract X509Credential getClientCredential();

    protected abstract Optional<Integer> getClientOpts();

    protected abstract void loadClientCredential() throws XrootdException;

    protected abstract boolean usePadded();

    protected class CertResponseBuckets
    extends GSIBucketContainerBuilder {
        XrootdBucket mainBucket;
        RawBucket dhParamsBucket;
        StringBucket cipherBucket;
        StringBucket digestBucket;
        StringBucket publicKeyBucket;
        StringBucket userNameBucket;

        public CertResponseBuckets(XrootdBucket mainBucket, byte[] dhParams, XrootdSecurityProtocol.BucketType dhParamType, Optional<String> publicKeyPem, Optional<String> userName, String selectedCipher, String selectedDigest) {
            this.mainBucket = mainBucket;
            this.dhParamsBucket = new RawBucket(dhParamType, dhParams);
            this.cipherBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg, selectedCipher);
            this.digestBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_md_alg, selectedDigest);
            if (publicKeyPem.isPresent()) {
                this.publicKeyBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_puk, publicKeyPem.get());
            }
            if (userName.isPresent()) {
                this.userNameBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_user, userName.get());
            }
        }

        @Override
        public GSIBucketContainer buildContainer() {
            return CertResponseBuckets.build(new XrootdBucket[]{this.mainBucket, this.cipherBucket, this.digestBucket, this.dhParamsBucket, this.publicKeyBucket, this.userNameBucket});
        }
    }

    protected class CertRequestBuckets
    extends GSIBucketContainerBuilder {
        private StringBucket cryptoBucket;
        private UnsignedIntBucket versionBucket;
        private StringBucket issuerBucket;
        private UnsignedIntBucket optionBucket;
        private NestedBucketBuffer mainBucket;

        public CertRequestBuckets(String rtag, Optional<Integer> opts) throws XrootdException {
            EnumMap<XrootdSecurityProtocol.BucketType, StringBucket> nestedBuckets = new EnumMap<XrootdSecurityProtocol.BucketType, StringBucket>(XrootdSecurityProtocol.BucketType.class);
            StringBucket randomTagBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_rtag, rtag);
            nestedBuckets.put(randomTagBucket.getType(), randomTagBucket);
            this.mainBucket = new NestedBucketBuffer(XrootdSecurityProtocol.BucketType.kXRS_main, "gsi", 1000, nestedBuckets);
            this.cryptoBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cryptomod, "ssl");
            this.versionBucket = new UnsignedIntBucket(XrootdSecurityProtocol.BucketType.kXRS_version, GSIClientRequestHandler.this.getProtocolVersion());
            this.issuerBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_issuer_hash, GSIClientRequestHandler.this.credentialManager.getIssuerHashes());
            if (opts.isPresent()) {
                this.optionBucket = new UnsignedIntBucket(XrootdSecurityProtocol.BucketType.kXRS_clnt_opts, opts.get().intValue());
            }
        }

        @Override
        public GSIBucketContainer buildContainer() {
            return GSIBucketContainerBuilder.build(new XrootdBucket[]{this.cryptoBucket, this.versionBucket, this.issuerBucket, this.mainBucket, this.optionBucket});
        }
    }
}

