/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSASession {
    protected static Logger LOGGER = LoggerFactory.getLogger(RSASession.class);
    protected Cipher cipher;
    protected int maxDecryptionBlockSize;
    protected int maxEncryptionBlockSize;

    public void initializeForEncryption(PrivateKey privateKey) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
        this.cipher.init(1, privateKey);
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)privateKey;
        this.maxEncryptionBlockSize = rsaPrivateKey.getModulus().bitLength() / 8 - 11;
        LOGGER.debug("RSA cipher initialized for encryption using private key of length {}, max block size {}.", (Object)rsaPrivateKey.getEncoded().length, (Object)this.maxEncryptionBlockSize);
    }

    public void initializeForDecryption(PublicKey publicKey) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding", "BC");
        this.cipher.init(2, publicKey);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        this.maxDecryptionBlockSize = rsaPublicKey.getModulus().bitLength() / 8;
        LOGGER.debug("RSA cipher initialized for decryption using public key of length {}, max block size {}.", (Object)rsaPublicKey.getEncoded().length, (Object)this.maxEncryptionBlockSize);
    }

    public byte[] encrypt(byte[] in) throws IOException, BadPaddingException, IllegalBlockSizeException {
        LOGGER.debug("RSA cipher encryption, incoming length {}; max block {}.", (Object)in.length, (Object)this.maxEncryptionBlockSize);
        return this.translate(in, this.maxEncryptionBlockSize);
    }

    public byte[] decrypt(byte[] in) throws IOException, BadPaddingException, IllegalBlockSizeException {
        LOGGER.debug("RSA cipher decryption, in length {}; max block {}.", (Object)in.length, (Object)this.maxDecryptionBlockSize);
        return this.translate(in, this.maxDecryptionBlockSize);
    }

    private byte[] translate(byte[] in, int maxBlockLen) throws BadPaddingException, IllegalBlockSizeException, IOException {
        int blockLen;
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] block = new byte[maxBlockLen];
        for (int len = in.length; len > 0; len -= blockLen) {
            blockLen = Math.min(len, maxBlockLen);
            LOGGER.debug("RSA cipher processing block of length {}.", (Object)blockLen);
            inStream.read(block, 0, blockLen);
            outStream.write(this.cipher.doFinal(block, 0, blockLen));
        }
        return outStream.toByteArray();
    }
}

