/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.GSIRequestHandler;
import org.dcache.xrootd.security.RawBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(DHSession.class);
    private static final String DH_ALGORITHM_NAME = "DH";
    private static final String DH_HEADER = "-----BEGIN DH PARAMETERS-----";
    private static final String DH_FOOTER = "-----END DH PARAMETERS-----";
    private static final String DH_PUBKEY_HEADER = "---BPUB---";
    private static final String DH_PUBKEY_FOOTER = "---EPUB---";
    private static final String DH_PRIME = "00:a8:37:9d:6f:ff:e8:63:a0:b1:47:0c:26:dd:1a:45:0b:e2:03:9a:f0:83:b1:ba:5b:fa:1d:2f:5b:2a:89:08:02:d8:c4:d4:66:8d:14:8d:35:bb:24:b1:af:1a:d3:75:c7:c0:3b:61:aa:85:3f:56:69:ae:f2:67:da:20:87:5d:93".replaceAll("[:\\s]+", "");
    static final DHParameterSpec DH_PARAMETERS = new DHParameterSpec(new BigInteger(DH_PRIME, 16), BigInteger.valueOf(2L));
    private DHParameterSpec _dhParameterSpec;
    private KeyPair _localDHKeyPair;
    private KeyAgreement _keyAgreement;
    private int _sessionIVLen;
    private byte[] IV;
    private boolean paddedKey;

    public DHSession(boolean isServer, int sessionIVLen) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        if (isServer) {
            this._dhParameterSpec = DH_PARAMETERS;
            this.initialize();
        }
        this._sessionIVLen = sessionIVLen;
        this.paddedKey = false;
    }

    private void initialize() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        KeyPairGenerator kpairGen = KeyPairGenerator.getInstance(DH_ALGORITHM_NAME, "BC");
        kpairGen.initialize(this._dhParameterSpec);
        this._localDHKeyPair = kpairGen.generateKeyPair();
        this._keyAgreement = KeyAgreement.getInstance(DH_ALGORITHM_NAME, "BC");
        this._keyAgreement.init(this._localDHKeyPair.getPrivate());
    }

    public String getEncodedDHMaterial() throws IOException {
        String dhparams = CertUtil.toPEM(DHSession.toDER(this._dhParameterSpec), DH_HEADER, DH_FOOTER);
        DHPublicKey pubkey = (DHPublicKey)this._localDHKeyPair.getPublic();
        return dhparams + '\n' + DH_PUBKEY_HEADER + pubkey.getY().toString(16) + DH_PUBKEY_FOOTER;
    }

    public void finaliseKeyAgreement(String dhmessage) throws IOException, GeneralSecurityException, IllegalStateException {
        int delimitingIndex = dhmessage.indexOf(DH_PUBKEY_HEADER);
        if (delimitingIndex < 0 || delimitingIndex >= dhmessage.length()) {
            throw new IllegalArgumentException("Illegal DH message: " + dhmessage);
        }
        String dhparams = dhmessage.substring(0, delimitingIndex);
        String remotePubKeyString = dhmessage.substring(delimitingIndex);
        DHParameterSpec params = DHSession.fromDER(CertUtil.fromPEM(dhparams, DH_HEADER, DH_FOOTER));
        LOGGER.debug("Remote endpoint sent: P = {}, G = {}, L = {},", new Object[]{params.getP(), params.getG(), params.getL()});
        if (this._keyAgreement == null) {
            int l = params.getL();
            this._dhParameterSpec = new DHParameterSpec(params.getP(), params.getG(), l == 0 ? params.getP().bitLength() : l);
            this.initialize();
        } else if (!this._dhParameterSpec.getP().equals(params.getP()) || !this._dhParameterSpec.getG().equals(params.getG())) {
            throw new GeneralSecurityException("remote DH parameters differ from local ones");
        }
        DHSession.removeCharFromString(remotePubKeyString, '\n');
        int envLength = DH_PUBKEY_HEADER.length();
        remotePubKeyString = remotePubKeyString.substring(envLength, remotePubKeyString.length() - envLength);
        BigInteger remoteY = new BigInteger(remotePubKeyString, 16);
        KeyFactory keyfac = KeyFactory.getInstance(DH_ALGORITHM_NAME, "BC");
        PublicKey remotePubKey = keyfac.generatePublic(new DHPublicKeySpec(remoteY, params.getP(), params.getG()));
        this._keyAgreement.doPhase(remotePubKey, true);
    }

    public byte[] decrypt(String cipherSpec, String keySpec, int blocksize, byte[] encrypted) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        StringBuilder builder = null;
        if (LOGGER.isTraceEnabled()) {
            builder = new StringBuilder();
            RawBucket.dumpBytes((StringBuilder)builder, (byte[])encrypted);
            LOGGER.trace("encrypted:\n{}", (Object)builder.toString());
        }
        encrypted = this.getIVFromMessagePrefix(encrypted, blocksize);
        byte[] decrypted = this.translate(cipherSpec, keySpec, blocksize, encrypted, 2);
        if (LOGGER.isTraceEnabled()) {
            builder = new StringBuilder();
            RawBucket.dumpBytes((StringBuilder)builder, (byte[])decrypted);
            LOGGER.trace("decrypted:\n{}", (Object)builder.toString());
        }
        return decrypted;
    }

    public void setPaddedKey(boolean paddedKey) {
        this.paddedKey = paddedKey;
    }

    public void setSessionIVLen(int len) {
        LOGGER.debug("Setting sessionIVLen to {}.", (Object)len);
        this._sessionIVLen = len;
    }

    public byte[] encrypt(String cipherSpec, String keySpec, int blocksize, byte[] unencrypted) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        StringBuilder builder = null;
        if (LOGGER.isTraceEnabled()) {
            builder = new StringBuilder();
            RawBucket.dumpBytes((StringBuilder)builder, (byte[])unencrypted);
            LOGGER.trace("unencrypted:\n{}", (Object)builder.toString());
        }
        this.refreshIV(blocksize);
        unencrypted = this.prefixedBuffer(unencrypted);
        byte[] encrypted = this.translate(cipherSpec, keySpec, blocksize, unencrypted, 1);
        LOGGER.trace("encrypted:");
        if (LOGGER.isTraceEnabled()) {
            builder.setLength(0);
            RawBucket.dumpBytes((StringBuilder)builder, (byte[])encrypted);
            LOGGER.trace("encrypted:\n{}", (Object)builder.toString());
        }
        return encrypted;
    }

    private byte[] getIVFromMessagePrefix(byte[] encrypted, int blocksize) {
        StringBuilder builder = null;
        if (this._sessionIVLen == 0) {
            this.IV = new byte[blocksize];
            if (LOGGER.isTraceEnabled()) {
                builder = new StringBuilder();
                RawBucket.dumpBytes((StringBuilder)builder, (byte[])this.IV);
                LOGGER.trace("initialization vector:\n{}", (Object)builder.toString());
            }
            return encrypted;
        }
        this.IV = Arrays.copyOf(encrypted, this._sessionIVLen);
        if (LOGGER.isTraceEnabled()) {
            builder = new StringBuilder();
            RawBucket.dumpBytes((StringBuilder)builder, (byte[])this.IV);
            LOGGER.trace("initialization vector:\n{}", (Object)builder.toString());
        }
        byte[] extracted = new byte[encrypted.length - this._sessionIVLen];
        System.arraycopy(encrypted, this._sessionIVLen, extracted, 0, encrypted.length - this._sessionIVLen);
        return extracted;
    }

    private byte[] prefixedBuffer(byte[] in) {
        if (this._sessionIVLen == 0) {
            return in;
        }
        byte[] out = new byte[this.IV.length + in.length];
        System.arraycopy(this.IV, 0, out, 0, this.IV.length);
        System.arraycopy(in, 0, out, this.IV.length, in.length);
        return out;
    }

    private void refreshIV(int blocksize) {
        this.IV = new byte[blocksize];
        if (this._sessionIVLen > 0) {
            for (int i = 0; i < this._sessionIVLen; ++i) {
                byte next;
                while (!((next = (byte)GSIRequestHandler.RANDOM.nextInt(127)) >= 46 && next <= 57 || next >= 65 && next <= 90 || next >= 97 && next <= 122)) {
                }
                this.IV[i] = next;
            }
        }
    }

    private byte[] translate(String cipherSpec, String keySpec, int blocksize, byte[] buffer, int mode) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        byte[] encoded;
        IvParameterSpec paramSpec = new IvParameterSpec(this.IV);
        Cipher cipher = Cipher.getInstance(cipherSpec, "BC");
        if (this.paddedKey) {
            LOGGER.info("Using padded DH secret generation.");
            encoded = this._keyAgreement.generateSecret();
        } else {
            LOGGER.info("Using unpadded (TlsPremasterSecret) DH secret generation.");
            encoded = this._keyAgreement.generateSecret("TlsPremasterSecret").getEncoded();
        }
        if (encoded.length < blocksize && mode == 1) {
            byte[] defective = encoded;
            encoded = Arrays.copyOf(defective, blocksize);
            LOGGER.info("Adjusting truncated encoded array by appending 0s.");
            if (LOGGER.isTraceEnabled()) {
                StringBuilder oldB = new StringBuilder();
                StringBuilder newB = new StringBuilder();
                RawBucket.dumpBytes((StringBuilder)oldB, (byte[])defective);
                RawBucket.dumpBytes((StringBuilder)newB, (byte[])encoded);
                LOGGER.trace("OLD:\n{}\nNEW:\n{}", (Object)oldB.toString(), (Object)newB.toString());
            }
        }
        SecretKeySpec sessionKey = new SecretKeySpec(encoded, 0, blocksize, keySpec);
        cipher.init(mode, (Key)sessionKey, paramSpec);
        return cipher.doFinal(buffer);
    }

    private static String removeCharFromString(String s, char c) {
        return s.replaceAll(String.valueOf(c), "");
    }

    private static DHParameterSpec fromDER(byte[] der) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(der);
        ASN1InputStream derInputStream = new ASN1InputStream((InputStream)inStream);
        DHParameter dhparam = DHParameter.getInstance((Object)derInputStream.readObject());
        return new DHParameterSpec(dhparam.getP(), dhparam.getG());
    }

    private static byte[] toDER(DHParameterSpec paramspec) throws IOException {
        DHParameter derParams = new DHParameter(paramspec.getP(), paramspec.getG(), paramspec.getP().bitLength());
        return derParams.getEncoded("DER");
    }
}

