/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.impl.PEMCredential;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.GSIServerRequestHandler;
import org.dcache.xrootd.plugins.authn.gsi.post49.GSIPost49ServerRequestHandler;
import org.dcache.xrootd.plugins.authn.gsi.pre49.GSIPre49ServerRequestHandler;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.BufferDecrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSIAuthenticationHandler
implements AuthenticationHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GSIAuthenticationHandler.class);
    private final Subject subject;
    private final GSICredentialManager credentialManager;
    private GSIServerRequestHandler requestHandler;
    private boolean finished = false;

    public GSIAuthenticationHandler(GSICredentialManager credentialManager) {
        this.credentialManager = credentialManager;
        this.subject = new Subject();
    }

    public XrootdResponse<AuthenticationRequest> authenticate(AuthenticationRequest request) throws XrootdException {
        XrootdResponse<AuthenticationRequest> response;
        if (!"gsi".equalsIgnoreCase(request.getProtocol())) {
            this.requestHandler.cancelHandshake();
            throw new XrootdException(3006, "Specified Protocol " + request.getProtocol() + " is not the protocol that was negotiated.");
        }
        if (this.requestHandler == null) {
            this.requestHandler = this.createRequestHandler(request.getVersion());
        }
        if (this.requestHandler.isRequestExpired()) {
            this.requestHandler.cancelHandshake();
            throw new XrootdException(3006, "Client authentication request time expired.");
        }
        switch (request.getStep()) {
            case 0: {
                response = new XrootdResponse<AuthenticationRequest>((XrootdRequest)request);
                break;
            }
            case 1000: {
                response = this.requestHandler.handleCertReqStep(request);
                LOGGER.debug("authenticate, processed certreq step for stream {}, session {}.", (Object)request.getStreamId(), (Object)request.getSession());
                break;
            }
            case 1001: {
                response = this.requestHandler.handleCertStep(request);
                this.finished = this.requestHandler.isFinished(request);
                LOGGER.debug("authenticate, processed cert step for stream {}, session {}.", (Object)request.getStreamId(), (Object)request.getSession());
                break;
            }
            case 1002: {
                response = this.requestHandler.handleSigPxyStep(request);
                LOGGER.debug("authenticate, processed sigpxy step for stream {}, session {}.", (Object)request.getStreamId(), (Object)request.getSession());
                this.finished = this.requestHandler.isFinished(request);
                break;
            }
            default: {
                this.requestHandler.cancelHandshake();
                throw new XrootdException(3006, "Error during authentication, unknown processing step: " + request.getStep());
            }
        }
        this.requestHandler.updateLastRequest();
        return response;
    }

    public BufferDecrypter getDecrypter() {
        return this.requestHandler.getDecrypter();
    }

    public String getProtocol() {
        PEMCredential credential = this.credentialManager.getHostCredential();
        String subjectHash = CertUtil.computeMD5Hash(credential.getCertificate().getIssuerX500Principal());
        return "&P=gsi,v:10400,c:ssl,ca:" + subjectHash;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean isCompleted() {
        return this.finished;
    }

    private GSIServerRequestHandler createRequestHandler(Integer clientVersion) throws XrootdException {
        if (clientVersion == null) {
            throw new XrootdException(3006, "Client did not provide GSI protocol version number.");
        }
        GSIServerRequestHandler handler = clientVersion >= 10400 ? new GSIPost49ServerRequestHandler(this.subject, this.credentialManager) : new GSIPre49ServerRequestHandler(this.subject, this.credentialManager);
        LOGGER.info("Client protocol version was {}, using {}.", (Object)clientVersion, (Object)handler.getClass().getSimpleName());
        return handler;
    }
}

