/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.HostnameToCertificateChecker;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import eu.emi.security.authn.x509.proxy.ProxyRequestOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.ProxyDelegationClient;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.SerializableX509Credential;
import org.dcache.xrootd.plugins.authn.gsi.X509ProxyDelegationClient;
import org.dcache.xrootd.util.ProxyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSICredentialManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSICredentialManager.class);
    private static final HostnameToCertificateChecker CERT_CHECKER = new HostnameToCertificateChecker();
    private static final CertificateFactory CERTIFICATE_FACTORY;
    private final String caCertificatePath;
    private final X509CertChainValidator certChainValidator;
    private final long trustAnchorRefreshInterval;
    private final String hostCertificatePath;
    private final String hostKeyPath;
    private final long hostCertRefreshInterval;
    private final boolean verifyHostCertificate;
    private final String clientCertificatePath;
    private final String clientKeyPath;
    private final long proxyRefreshInterval;
    private final boolean verifyClientCertificate;
    private final String proxyPath;
    private long hostCertRefreshTimestamp = 0L;
    private long proxyRefreshTimestamp = 0L;
    private String issuerHashes;
    private PEMCredential hostCredential;
    private PEMCredential clientCredential;
    private X509Credential proxy;
    private X509ProxyDelegationClient proxyDelegationClient;
    private ProxyRequest<X509Certificate[], String> proxyRequest;

    public static void checkIdentity(X509Certificate certificate, String name) throws GeneralSecurityException, UnknownHostException {
        LOGGER.debug("Checking identity of certificate against source {}.", (Object)name);
        if (certificate.getSubjectDN().getName().contains(name) || CERT_CHECKER.checkMatching(name, certificate)) {
            return;
        }
        String error = "The name of the source server does not match any subject name of the received credential.";
        throw new GeneralSecurityException(error);
    }

    public X509Certificate createCertificate(byte[] bytes) throws CertificateException {
        return (X509Certificate)CERTIFICATE_FACTORY.generateCertificate(new ByteArrayInputStream(bytes));
    }

    public GSICredentialManager(Properties properties) {
        this.caCertificatePath = properties.getProperty("xrootd.gsi.ca.path");
        this.trustAnchorRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.ca.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.ca.refresh")));
        NamespaceCheckingMode namespaceMode = NamespaceCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.namespace-mode"));
        CrlCheckingMode crlCheckingMode = CrlCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.crl-mode"));
        OCSPCheckingMode ocspCheckingMode = OCSPCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.ocsp-mode"));
        ValidatorParams validatorParams = new ValidatorParams(new RevocationParameters(crlCheckingMode, new OCSPParametes(ocspCheckingMode)), ProxySupport.ALLOW);
        this.certChainValidator = new OpensslCertChainValidator(this.caCertificatePath, false, namespaceMode, this.trustAnchorRefreshInterval, validatorParams, false);
        this.hostKeyPath = properties.getProperty("xrootd.gsi.hostcert.key");
        this.hostCertificatePath = properties.getProperty("xrootd.gsi.hostcert.cert");
        this.hostCertRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.hostcert.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.hostcert.refresh")));
        this.verifyHostCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.hostcert.verify"));
        this.clientKeyPath = properties.getProperty("xrootd.gsi.tpc.cred.key");
        this.clientCertificatePath = properties.getProperty("xrootd.gsi.tpc.cred.cert");
        this.proxyRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.tpc.cred.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.tpc.cred.refresh")));
        this.verifyClientCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.tpc.cred.verify"));
        this.proxyPath = properties.getProperty("xrootd.gsi.tpc.proxy.path");
    }

    public synchronized void cancelOutstandingProxyRequest() {
        if (this.proxyRequest != null && this.proxyRequest.getId() != null) {
            try {
                this.proxyDelegationClient.cancelProxyRequest(this.proxyRequest);
            }
            catch (XrootdException e) {
                LOGGER.warn("Problem cancelling proxy delegation request {} {}: {}.", new Object[]{((X509Certificate[])this.proxyRequest.getKey())[0].getSubjectDN(), this.proxyRequest.getId(), e.toString()});
            }
            this.proxyRequest = null;
        }
    }

    public void checkCaIdentities(String[] caIdentities) throws XrootdException {
        ArrayList<String> valid = new ArrayList<String>();
        for (String ca : caIdentities) {
            if (!this.isValidCaPath(ca)) continue;
            valid.add(ca);
        }
        if (valid.isEmpty()) {
            throw new XrootdException(4003, "no ca identity is recognized.");
        }
        LOGGER.debug("The following ca hashes are recognized: {}.", valid);
    }

    public synchronized SerializableX509Credential finalizeDelegatedProxy(X509Certificate[] certChain) throws XrootdException {
        if (this.proxyRequest == null) {
            throw new XrootdException(3012, "cannot finalize proxy: proxy request was not sent.");
        }
        X509Certificate[] oldChain = (X509Certificate[])this.proxyRequest.getKey();
        String serializedCert = CertUtil.chainToPEM(CertUtil.prepend(certChain[0], oldChain));
        LOGGER.debug("finalizing proxy credential for {}, id {}.", (Object)oldChain[0].getSubjectDN(), (Object)this.proxyRequest.getId());
        SerializableX509Credential x509Credential = (SerializableX509Credential)this.proxyDelegationClient().finalizeProxyCredential(this.proxyRequest.getId(), (Serializable)((Object)serializedCert));
        this.proxyRequest = null;
        return x509Credential;
    }

    public X509CertChainValidator getCertChainValidator() {
        return this.certChainValidator;
    }

    public PEMCredential getHostCredential() {
        return this.hostCredential;
    }

    public String getIssuerHashes() {
        return this.issuerHashes;
    }

    public X509Credential getProxy() {
        return this.proxy;
    }

    public PublicKey getSenderPublicKey() {
        if (this.proxyRequest != null) {
            return ((X509Certificate[])this.proxyRequest.getKey())[0].getPublicKey();
        }
        return null;
    }

    public synchronized String prepareSerializedProxyRequest(X509Certificate[] certChain) throws XrootdException {
        LOGGER.debug("Credential manager requesting proxy request (CSR) from client for {}.", (Object)certChain[0].getSubjectDN());
        this.proxyRequest = this.proxyDelegationClient().getProxyRequest((Serializable)certChain);
        LOGGER.debug("Credential manager got proxy request (CSR) from client for {}.", (Object)certChain[0].getSubjectDN());
        if (this.proxyRequest == null) {
            throw new XrootdException(3012, "fetch of proxy request (CSR) failed");
        }
        return (String)((Object)this.proxyRequest.getRequest());
    }

    public synchronized X509Certificate[] getSignedProxyRequest(byte[] serverCSR) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, CertificateParsingException, NoSuchProviderException {
        ProxyRequestOptions options = new ProxyRequestOptions(this.proxy.getCertificateChain(), new PKCS10CertificationRequest(serverCSR));
        LOGGER.debug("Client, signing proxy request (CSR) with client private key {}.", (Object)this.proxy.getKey());
        return ProxyGenerator.generate((ProxyRequestOptions)options, (PrivateKey)this.proxy.getKey());
    }

    public synchronized void loadClientCredentials() {
        block8: {
            try {
                if (!this.shouldRefreshClientProxyCredential()) break block8;
                LOGGER.info("Refreshing proxy credential. Current refresh interval: {} ms", (Object)this.proxyRefreshInterval);
                if (!Strings.isNullOrEmpty((String)this.proxyPath)) {
                    this.clientCredential = new PEMCredential(this.proxyPath, (char[])null);
                    this.proxy = this.clientCredential;
                } else {
                    this.clientCredential = new PEMCredential(this.clientKeyPath, this.clientCertificatePath, null);
                    if (this.verifyClientCertificate) {
                        LOGGER.info("Verifying client certificate");
                        this.certChainValidator.validate(this.clientCredential.getCertificateChain());
                    }
                    try {
                        ProxyCertificateOptions options = new ProxyCertificateOptions(this.clientCredential.getCertificateChain());
                        ProxyCertificate proxyCert = ProxyGenerator.generate((ProxyCertificateOptions)options, (PrivateKey)this.clientCredential.getKey());
                        this.proxy = proxyCert.getCredential();
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                        throw new CertificateException("could not generate host proxy credential.", e);
                    }
                }
                this.proxyRefreshTimestamp = System.currentTimeMillis();
            }
            catch (GeneralSecurityException gssex) {
                LOGGER.error("Could not load certificates/key due to security error; {}: {}.", (Object)this.getCredentialValues(), (Object)gssex.toString());
            }
            catch (IOException ioex) {
                LOGGER.error("Could not read certificates/key from file-system; {}: {}.", (Object)this.getCredentialValues(), (Object)ioex.toString());
            }
        }
        this.issuerHashes = this.generateIssuerHashes(this.proxy);
    }

    public synchronized void loadServerCredentials() throws CertificateException, KeyStoreException, IOException {
        if (this.shouldReloadServerCredentials()) {
            LOGGER.info("Loading server certificates. Current refresh interval: {} ms", (Object)this.hostCertRefreshInterval);
            PEMCredential credential = new PEMCredential(this.hostKeyPath, this.hostCertificatePath, null);
            if (this.verifyHostCertificate) {
                LOGGER.info("Verifying host certificate");
                this.certChainValidator.validate(credential.getCertificateChain());
            }
            this.hostCredential = credential;
            this.hostCertRefreshTimestamp = System.currentTimeMillis();
        }
    }

    public void setProxyDelegationClient(ProxyDelegationClient proxyDelegationClient) {
        this.proxyDelegationClient = (X509ProxyDelegationClient)proxyDelegationClient;
    }

    public void setIssuerHashes(X509Credential credential) {
        this.issuerHashes = this.generateIssuerHashes(credential);
    }

    private X509ProxyDelegationClient proxyDelegationClient() throws XrootdException {
        if (this.proxyDelegationClient == null) {
            throw new XrootdException(3012, "no client to credential store has been provided.");
        }
        return this.proxyDelegationClient;
    }

    private String generateIssuerHashes(X509Credential credential) {
        HashSet<String> issuers = new HashSet<String>();
        for (X509Certificate cert : credential.getCertificateChain()) {
            X500Principal certIssuer = cert.getIssuerX500Principal();
            issuers.add(OpensslTruststoreHelper.getOpenSSLCAHash((X500Principal)certIssuer, (boolean)true));
        }
        return Joiner.on((String)"|").join(issuers);
    }

    private String getCredentialValues() {
        return "client cert path: " + this.clientCertificatePath + ", client key path: " + this.clientKeyPath + ", client issuer hashes: " + this.issuerHashes + ", proxy path: " + this.proxyPath;
    }

    private boolean isValidCaPath(String path) {
        if ((path = path.trim()).indexOf(".") < 1) {
            path = path + ".0";
        }
        return new File(this.caCertificatePath, path).exists();
    }

    private boolean shouldReloadServerCredentials() {
        long timeSinceLastServerRefresh = System.currentTimeMillis() - this.hostCertRefreshTimestamp;
        LOGGER.info("Time since last server cert refresh {}", (Object)timeSinceLastServerRefresh);
        return this.hostCredential == null || timeSinceLastServerRefresh >= this.hostCertRefreshInterval;
    }

    private boolean shouldRefreshClientProxyCredential() {
        long timeSinceLastClientRefresh = System.currentTimeMillis() - this.proxyRefreshTimestamp;
        LOGGER.info("Time since last client cert refresh {}", (Object)timeSinceLastClientRefresh);
        return this.proxy == null || timeSinceLastClientRefresh >= this.proxyRefreshInterval;
    }

    static {
        try {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to create X.509 certificate factory: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Failed to load bouncy castle provider: " + e.getMessage(), e);
        }
    }
}

