/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import com.google.common.base.Strings;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialLoader.class);
    private final X509CertChainValidator certChainValidator;
    private final String hostCertificatePath;
    private final String hostKeyPath;
    private final long hostCertRefreshInterval;
    private final boolean verifyHostCertificate;
    private final String clientCertificatePath;
    private final String clientKeyPath;
    private final long proxyRefreshInterval;
    private final boolean verifyClientCertificate;
    private final String proxyPath;
    private long hostCertRefreshTimestamp = 0L;
    private long proxyRefreshTimestamp = 0L;
    private PEMCredential hostCredential;
    private PEMCredential clientCredential;
    private X509Credential proxy;

    public CredentialLoader(Properties properties, X509CertChainValidator certChainValidator) {
        this.certChainValidator = certChainValidator;
        this.hostKeyPath = properties.getProperty("xrootd.gsi.hostcert.key");
        this.hostCertificatePath = properties.getProperty("xrootd.gsi.hostcert.cert");
        this.hostCertRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.hostcert.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.hostcert.refresh")));
        this.verifyHostCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.hostcert.verify"));
        this.clientKeyPath = properties.getProperty("xrootd.gsi.tpc.cred.key");
        this.clientCertificatePath = properties.getProperty("xrootd.gsi.tpc.cred.cert");
        this.proxyRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.tpc.cred.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.tpc.cred.refresh")));
        this.verifyClientCertificate = Boolean.parseBoolean(properties.getProperty("xrootd.gsi.tpc.cred.verify"));
        this.proxyPath = properties.getProperty("xrootd.gsi.tpc.proxy.path");
    }

    public PEMCredential getHostCredential() {
        this.loadServerCredentials();
        return this.hostCredential;
    }

    public X509Credential getProxy() {
        this.loadClientCredentials();
        return this.proxy;
    }

    private synchronized void loadClientCredentials() {
        block8: {
            try {
                if (!this.shouldRefreshClientProxyCredential()) break block8;
                LOGGER.info("Refreshing proxy credential. Current refresh interval: {} ms", (Object)this.proxyRefreshInterval);
                if (!Strings.isNullOrEmpty((String)this.proxyPath)) {
                    this.clientCredential = new PEMCredential(this.proxyPath, (char[])null);
                    this.proxy = this.clientCredential;
                } else {
                    this.clientCredential = new PEMCredential(this.clientKeyPath, this.clientCertificatePath, null);
                    if (this.verifyClientCertificate) {
                        LOGGER.info("Verifying client certificate");
                        this.certChainValidator.validate(this.clientCredential.getCertificateChain());
                    }
                    try {
                        ProxyCertificateOptions options = new ProxyCertificateOptions(this.clientCredential.getCertificateChain());
                        ProxyCertificate proxyCert = ProxyGenerator.generate((ProxyCertificateOptions)options, (PrivateKey)this.clientCredential.getKey());
                        this.proxy = proxyCert.getCredential();
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                        throw new CertificateException("could not generate host proxy credential.", e);
                    }
                }
                this.proxyRefreshTimestamp = System.currentTimeMillis();
            }
            catch (GeneralSecurityException gssex) {
                LOGGER.error("Could not load client certificates/key due to security error; {}: {}.", (Object)this.getCredentialValues(), (Object)gssex.toString());
            }
            catch (IOException ioex) {
                LOGGER.error("Could not read client certificates/key from file-system; {}: {}.", (Object)this.getCredentialValues(), (Object)ioex.toString());
            }
        }
    }

    private synchronized void loadServerCredentials() {
        try {
            if (this.shouldReloadServerCredentials()) {
                LOGGER.info("Loading server certificates. Current refresh interval: {} ms", (Object)this.hostCertRefreshInterval);
                PEMCredential credential = new PEMCredential(this.hostKeyPath, this.hostCertificatePath, null);
                if (this.verifyHostCertificate) {
                    LOGGER.info("Verifying host certificate");
                    this.certChainValidator.validate(credential.getCertificateChain());
                }
                this.hostCredential = credential;
                this.hostCertRefreshTimestamp = System.currentTimeMillis();
            }
        }
        catch (GeneralSecurityException gssex) {
            LOGGER.error("Could not load server certificates/key due to security error; {}: {}.", (Object)this.getCredentialValues(), (Object)gssex.toString());
        }
        catch (IOException ioex) {
            LOGGER.error("Could not read server certificates/key from file-system; {}: {}.", (Object)this.getCredentialValues(), (Object)ioex.toString());
        }
    }

    private String getCredentialValues() {
        return "client cert path: " + this.clientCertificatePath + ", client key path: " + this.clientKeyPath + ", proxy path: " + this.proxyPath;
    }

    private boolean shouldReloadServerCredentials() {
        long timeSinceLastServerRefresh = System.currentTimeMillis() - this.hostCertRefreshTimestamp;
        LOGGER.info("Time since last server cert refresh {}", (Object)timeSinceLastServerRefresh);
        return this.hostCredential == null || timeSinceLastServerRefresh >= this.hostCertRefreshInterval;
    }

    private boolean shouldRefreshClientProxyCredential() {
        long timeSinceLastClientRefresh = System.currentTimeMillis() - this.proxyRefreshTimestamp;
        LOGGER.info("Time since last client cert refresh {}", (Object)timeSinceLastClientRefresh);
        return this.proxy == null || timeSinceLastClientRefresh >= this.proxyRefreshInterval;
    }
}

