/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import com.google.common.base.Joiner;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.HostnameToCertificateChecker;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import eu.emi.security.authn.x509.proxy.ProxyRequestOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.ProxyDelegationClient;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.CredentialLoader;
import org.dcache.xrootd.plugins.authn.gsi.SerializableX509Credential;
import org.dcache.xrootd.plugins.authn.gsi.X509ProxyDelegationClient;
import org.dcache.xrootd.util.ProxyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSICredentialManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSICredentialManager.class);
    private static final HostnameToCertificateChecker CERT_CHECKER = new HostnameToCertificateChecker();
    private static final CertificateFactory CERTIFICATE_FACTORY;
    private final CredentialLoader credentialLoader;
    private final String caCertificatePath;
    private final X509CertChainValidator certChainValidator;
    private String issuerHashes;
    private X509ProxyDelegationClient proxyDelegationClient;
    private ProxyRequest<X509Certificate[], String> proxyRequest;

    public static void checkIdentity(X509Certificate certificate, String name) throws GeneralSecurityException, UnknownHostException {
        LOGGER.debug("Checking identity of certificate against source {}.", (Object)name);
        if (certificate.getSubjectDN().getName().contains(name) || CERT_CHECKER.checkMatching(name, certificate)) {
            return;
        }
        String error = "The name of the source server does not match any subject name of the received credential.";
        throw new GeneralSecurityException(error);
    }

    private static String generateIssuerHashes(X509Credential credential) {
        HashSet<String> issuers = new HashSet<String>();
        for (X509Certificate cert : credential.getCertificateChain()) {
            X500Principal certIssuer = cert.getIssuerX500Principal();
            issuers.add(OpensslTruststoreHelper.getOpenSSLCAHash((X500Principal)certIssuer, (boolean)true));
        }
        return Joiner.on((String)"|").join(issuers);
    }

    public X509Certificate createCertificate(byte[] bytes) throws CertificateException {
        return (X509Certificate)CERTIFICATE_FACTORY.generateCertificate(new ByteArrayInputStream(bytes));
    }

    public GSICredentialManager(Properties properties, CredentialLoader credentialLoader, X509CertChainValidator certChainValidator) {
        this.caCertificatePath = properties.getProperty("xrootd.gsi.ca.path");
        this.credentialLoader = credentialLoader;
        this.certChainValidator = certChainValidator;
    }

    public synchronized void cancelOutstandingProxyRequest() {
        if (this.proxyRequest != null && this.proxyRequest.getId() != null) {
            try {
                this.proxyDelegationClient.cancelProxyRequest(this.proxyRequest);
            }
            catch (XrootdException e) {
                LOGGER.warn("Problem cancelling proxy delegation request {} {}: {}.", new Object[]{((X509Certificate[])this.proxyRequest.getKey())[0].getSubjectDN(), this.proxyRequest.getId(), e.toString()});
            }
            this.proxyRequest = null;
        }
    }

    public void checkCaIdentities(String[] caIdentities) throws XrootdException {
        ArrayList<String> valid = new ArrayList<String>();
        for (String ca : caIdentities) {
            if (!this.isValidCaPath(ca)) continue;
            valid.add(ca);
        }
        if (valid.isEmpty()) {
            throw new XrootdException(10026, "no ca identity is recognized.");
        }
        LOGGER.debug("The following ca hashes are recognized: {}.", valid);
    }

    public synchronized SerializableX509Credential finalizeDelegatedProxy(X509Certificate[] certChain) throws XrootdException {
        if (this.proxyRequest == null) {
            throw new XrootdException(10026, "cannot finalize proxy: proxy request was not sent.");
        }
        X509Certificate[] oldChain = (X509Certificate[])this.proxyRequest.getKey();
        String serializedCert = CertUtil.chainToPEM(CertUtil.prepend(certChain[0], oldChain));
        LOGGER.debug("finalizing proxy credential for {}, id {}.", (Object)oldChain[0].getSubjectDN(), (Object)this.proxyRequest.getId());
        SerializableX509Credential x509Credential = (SerializableX509Credential)this.proxyDelegationClient().finalizeProxyCredential(this.proxyRequest.getId(), (Serializable)((Object)serializedCert));
        this.proxyRequest = null;
        return x509Credential;
    }

    public X509CertChainValidator getCertChainValidator() {
        return this.certChainValidator;
    }

    public PEMCredential getHostCredential() {
        return this.credentialLoader.getHostCredential();
    }

    public String getIssuerHashes() {
        X509Credential proxy;
        if (this.issuerHashes == null && (proxy = this.getProxy()) != null) {
            this.issuerHashes = GSICredentialManager.generateIssuerHashes(proxy);
        }
        return this.issuerHashes;
    }

    public X509Credential getProxy() {
        return this.credentialLoader.getProxy();
    }

    public PublicKey getSenderPublicKey() {
        if (this.proxyRequest != null) {
            return ((X509Certificate[])this.proxyRequest.getKey())[0].getPublicKey();
        }
        return null;
    }

    public synchronized String prepareSerializedProxyRequest(X509Certificate[] certChain) throws XrootdException {
        LOGGER.debug("Credential manager requesting proxy request (CSR) from client for {}.", (Object)certChain[0].getSubjectDN());
        this.proxyRequest = this.proxyDelegationClient().getProxyRequest((Serializable)certChain);
        LOGGER.debug("Credential manager got proxy request (CSR) from client for {}.", (Object)certChain[0].getSubjectDN());
        if (this.proxyRequest == null) {
            throw new XrootdException(10026, "fetch of proxy request (CSR) failed");
        }
        return (String)((Object)this.proxyRequest.getRequest());
    }

    public synchronized X509Certificate[] getSignedProxyRequest(byte[] serverCSR) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, CertificateParsingException, NoSuchProviderException {
        ProxyRequestOptions options = new ProxyRequestOptions(this.credentialLoader.getProxy().getCertificateChain(), new PKCS10CertificationRequest(serverCSR));
        LOGGER.debug("Client, signing proxy request (CSR) with client private key {}.", (Object)this.credentialLoader.getProxy().getKey());
        return ProxyGenerator.generate((ProxyRequestOptions)options, (PrivateKey)this.credentialLoader.getProxy().getKey());
    }

    public void setProxyDelegationClient(ProxyDelegationClient proxyDelegationClient) {
        this.proxyDelegationClient = (X509ProxyDelegationClient)proxyDelegationClient;
    }

    public void setIssuerHashesFromCredential(X509Credential credential) {
        this.issuerHashes = GSICredentialManager.generateIssuerHashes(credential);
    }

    private X509ProxyDelegationClient proxyDelegationClient() throws XrootdException {
        if (this.proxyDelegationClient == null) {
            throw new XrootdException(10026, "no client to credential store has been provided.");
        }
        return this.proxyDelegationClient;
    }

    private boolean isValidCaPath(String path) {
        if ((path = path.trim()).indexOf(".") < 1) {
            path = path + ".0";
        }
        return new File(this.caCertificatePath, path).exists();
    }

    static {
        try {
            CERTIFICATE_FACTORY = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to create X.509 certificate factory: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Failed to load bouncy castle provider: " + e.getMessage(), e);
        }
    }
}

