/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi.post49;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.security.KeyStoreException;
import java.util.Optional;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainer;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainerBuilder;
import org.dcache.xrootd.plugins.authn.gsi.GSIClientRequestHandler;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.SerializableX509Credential;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.dcache.xrootd.tpc.XrootdTpcClient;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundErrorResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundAuthenticationRequest;

public class GSIPost49ClientRequestHandler
extends GSIClientRequestHandler {
    private X509Credential delegatedProxy;

    public GSIPost49ClientRequestHandler(GSICredentialManager credentialManager, XrootdTpcClient client) {
        super(credentialManager, client);
        client.getAuthnContext().put("tpcdlg", "gsi");
    }

    @Override
    public int getProtocolVersion() {
        return 10400;
    }

    @Override
    protected void handleAuthenticationError(InboundErrorResponse response) throws XrootdException {
        String message = response.getErrorMessage() + " \u2013\u2013 user proxy was " + this.client.getInfo().getDelegatedProxy() == null ? "not " : "delegated.";
        throw new XrootdException(response.getError(), message);
    }

    @Override
    public OutboundAuthenticationRequest handleCertStep(InboundAuthenticationResponse response, ChannelHandlerContext ctx) throws XrootdException {
        return this.handleCertStep(response, ctx, XrootdSecurityProtocol.BucketType.kXRS_cipher, true, Optional.of(this.getClientPublicKeyPem()), Optional.of(this.client.getUname()));
    }

    @Override
    protected X509Credential getClientCredential() {
        return this.delegatedProxy;
    }

    @Override
    protected Optional<Integer> getClientOpts() {
        return Optional.of(0);
    }

    @Override
    protected String getSyncCipherMode() {
        return "AES/CBC/NoPadding";
    }

    @Override
    protected void loadClientCredential() throws XrootdException {
        LOGGER.debug("Loading client credential.");
        Serializable serializable = this.client.getInfo().getDelegatedProxy();
        if (serializable != null) {
            try {
                SerializableX509Credential proxy = (SerializableX509Credential)serializable;
                this.delegatedProxy = new KeyAndCertCredential(proxy.getPrivateKey(), proxy.getCertChain());
                this.credentialManager.setIssuerHashesFromCredential(this.delegatedProxy);
            }
            catch (ClassCastException e) {
                throw new XrootdException(10026, "delegated proxy was of wrong type: " + serializable.getClass());
            }
            catch (KeyStoreException e) {
                throw new XrootdException(10026, "problem with delegated proxy: " + e.getMessage());
            }
        }
    }

    @Override
    protected boolean usePadded() {
        return !this.noPadding;
    }

    @Override
    protected String validateCiphers(InboundAuthenticationResponse inbound) throws XrootdException {
        return super.validateCiphers(inbound) + "#" + 16;
    }

    private String getClientPublicKeyPem() {
        return CertUtil.toPEM(this.delegatedProxy.getCertificate().getPublicKey().getEncoded(), "-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
    }

    protected class PxyreqResponseBuckets
    extends GSIBucketContainerBuilder {
        private XrootdBucket mainBucket;

        public PxyreqResponseBuckets(XrootdBucket mainBucket) throws XrootdException {
            this.mainBucket = mainBucket;
        }

        @Override
        public GSIBucketContainer buildContainer() {
            return GSIBucketContainerBuilder.build(this.mainBucket);
        }
    }
}

