/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.util.Properties;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.ProxyDelegationClient;
import org.dcache.xrootd.plugins.authn.gsi.CertChainValidatorProvider;
import org.dcache.xrootd.plugins.authn.gsi.CredentialLoader;
import org.dcache.xrootd.plugins.authn.gsi.GSIAuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;

public class GSIAuthenticationFactory
implements AuthenticationFactory {
    private final Properties properties;
    private final CertChainValidatorProvider validatorProvider;
    private final CredentialLoader credentialLoader;

    public GSIAuthenticationFactory(Properties properties) {
        this.properties = properties;
        this.validatorProvider = new CertChainValidatorProvider(properties);
        this.credentialLoader = new CredentialLoader(properties, this.validatorProvider.getCertChainValidator());
    }

    public AuthenticationHandler createHandler(ProxyDelegationClient proxyDelegationClient) {
        GSICredentialManager credentialManager = new GSICredentialManager(this.properties, this.credentialLoader, this.validatorProvider.getCertChainValidator());
        credentialManager.setProxyDelegationClient(proxyDelegationClient);
        return new GSIAuthenticationHandler(credentialManager);
    }
}

