/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import io.netty.channel.ChannelHandler;
import java.util.Properties;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.authn.gsi.CertChainValidatorProvider;
import org.dcache.xrootd.plugins.authn.gsi.CredentialLoader;
import org.dcache.xrootd.plugins.authn.gsi.GSIClientAuthenticationHandler;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;

public class GSIClientAuthenticationFactory
implements ChannelHandlerFactory {
    private final Properties properties;
    private final CertChainValidatorProvider validatorProvider;
    private final CredentialLoader credentialLoader;

    public GSIClientAuthenticationFactory(Properties properties) {
        this.properties = properties;
        this.validatorProvider = new CertChainValidatorProvider(properties);
        this.credentialLoader = new CredentialLoader(properties, this.validatorProvider.getCertChainValidator());
    }

    public ChannelHandler createHandler() {
        GSICredentialManager credentialManager = new GSICredentialManager(this.properties, this.credentialLoader, this.validatorProvider.getCertChainValidator());
        return new GSIClientAuthenticationHandler(credentialManager);
    }

    public String getDescription() {
        return "GSI authentication client plugin for third-party transfers";
    }

    public String getName() {
        return "gsi";
    }
}

