/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.DHSession;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainer;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainerBuilder;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.GSIRequestHandler;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.AuthenticationResponse;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.BufferDecrypter;
import org.dcache.xrootd.security.NestedBucketBuffer;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.StringBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GSIServerRequestHandler
extends GSIRequestHandler {
    protected static Logger LOGGER = LoggerFactory.getLogger(GSIServerRequestHandler.class);
    protected final Subject subject;

    protected GSIServerRequestHandler(Subject subject, GSICredentialManager credentialManager) throws XrootdException {
        super(credentialManager);
        this.subject = subject;
        int sessionIVLen = this.getProtocolVersion() < 10400 ? 0 : 16;
        try {
            this.dhSession = new DHSession(true, sessionIVLen);
        }
        catch (GeneralSecurityException gssex) {
            LOGGER.error("Error setting up cryptographic classes: {}", (Object)gssex.getMessage());
            throw new XrootdException(10024, "dCache GSI module probably misconfigured.");
        }
    }

    public BufferDecrypter getDecrypter() {
        return this.bufferHandler;
    }

    public void cancelHandshake() {
        this.credentialManager.cancelOutstandingProxyRequest();
    }

    public abstract XrootdResponse<AuthenticationRequest> handleCertReqStep(AuthenticationRequest var1) throws XrootdException;

    public abstract XrootdResponse<AuthenticationRequest> handleCertStep(AuthenticationRequest var1) throws XrootdException;

    public abstract XrootdResponse<AuthenticationRequest> handleSigPxyStep(AuthenticationRequest var1) throws XrootdException;

    public abstract boolean isFinished(AuthenticationRequest var1);

    protected XrootdResponse<AuthenticationRequest> handleCertReqStep(AuthenticationRequest request, boolean signDHParams, XrootdSecurityProtocol.BucketType dhParamBucketType) throws XrootdException {
        try {
            StringBucket bucket = (StringBucket)request.getBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_cryptomod);
            this.validateCryptoMode(bucket.getContent());
            bucket = (StringBucket)request.getBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_issuer_hash);
            String caIdentities = bucket.getContent();
            this.credentialManager.checkCaIdentities(caIdentities.split("[|]"));
            PEMCredential credential = this.credentialManager.getHostCredential();
            this.rsaSession.initializeForEncryption(credential.getKey());
            NestedBucketBuffer mainBucket = (NestedBucketBuffer)request.getBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_main);
            XrootdBucket main = this.postProcessMainBucket(mainBucket.getNestedBuckets(), Optional.empty(), 2001);
            GSIBucketContainer responseBuckets = new CertRequestBuckets(main, "ssl", this.dhParams(signDHParams), dhParamBucketType, "aes-128-cbc", "sha1:md5", this.encodedHostCert(credential)).buildContainer();
            return new AuthenticationResponse(request, 4002, responseBuckets.getSize(), "gsi", 2001, responseBuckets.getBuckets());
        }
        catch (InvalidKeyException ikex) {
            LOGGER.error("Configured host-key could not be used for signing: {}", (Object)ikex.getMessage());
            throw new XrootdException(10026, "Error when trying to sign client authentication tag.");
        }
        catch (CertificateEncodingException cee) {
            LOGGER.error("Could not extract contents of server certificate: {}", (Object)cee.getMessage());
            throw new XrootdException(10026, "Error when trying to send server certificate.");
        }
        catch (IOException | GeneralSecurityException gssex) {
            LOGGER.error("Problems during signing of client authN tag (algorithm {}): {}", (Object)"RSA/NONE/PKCS1Padding", (Object)(gssex.getMessage() == null ? gssex.getClass().getName() : gssex.getMessage()));
            throw new XrootdException(10026, "Error when trying to sign client authentication tag.");
        }
    }

    protected String validateCiphers(AuthenticationRequest request) throws XrootdException {
        StringBucket cipherBucket = (StringBucket)request.getBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg);
        return this.validateCiphers(cipherBucket.getContent().split("[:]"));
    }

    protected String validateDigests(AuthenticationRequest request) throws XrootdException {
        StringBucket digestBucket = (StringBucket)request.getBuckets().get(XrootdSecurityProtocol.BucketType.kXRS_md_alg);
        return this.validateDigests(digestBucket.getContent().split("[:]"));
    }

    private String encodedHostCert(PEMCredential credential) throws CertificateEncodingException {
        LOGGER.debug("Getting encoded host certificate from PEM credential.");
        X509Certificate certificate = credential.getCertificate();
        return CertUtil.certToPEM(certificate);
    }

    protected class CertRequestBuckets
    extends GSIBucketContainerBuilder {
        XrootdBucket mainBucket;
        RawBucket dhPublicBucket;
        StringBucket cryptoBucket;
        StringBucket cipherBucket;
        StringBucket digestBucket;
        StringBucket hostCertBucket;

        public CertRequestBuckets(XrootdBucket mainBucket, String cryptoMode, byte[] signedDHParams, XrootdSecurityProtocol.BucketType dhParamBucketType, String supportedCiphers, String supportedDigests, String hostCertificate) {
            this.mainBucket = mainBucket;
            this.cryptoBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cryptomod, cryptoMode);
            this.dhPublicBucket = new RawBucket(dhParamBucketType, signedDHParams);
            this.cipherBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cipher_alg, supportedCiphers);
            this.digestBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_md_alg, supportedDigests);
            this.hostCertBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_x509, hostCertificate);
        }

        @Override
        public GSIBucketContainer buildContainer() {
            return CertRequestBuckets.build(new XrootdBucket[]{this.mainBucket, this.cryptoBucket, this.dhPublicBucket, this.cipherBucket, this.digestBucket, this.hostCertBucket});
        }
    }
}

