/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class CertChainValidatorProvider {
    private final String caCertificatePath;
    private final X509CertChainValidator certChainValidator;
    private final long trustAnchorRefreshInterval;

    public CertChainValidatorProvider(Properties properties) throws FileNotFoundException {
        this.caCertificatePath = properties.getProperty("xrootd.gsi.ca.path");
        if (!new File(this.caCertificatePath).isDirectory()) {
            throw new FileNotFoundException(this.caCertificatePath + " is missing: GSI requires the X509 certificate authority CRLs");
        }
        this.trustAnchorRefreshInterval = TimeUnit.valueOf(properties.getProperty("xrootd.gsi.ca.refresh.unit")).toMillis(Integer.parseInt(properties.getProperty("xrootd.gsi.ca.refresh")));
        NamespaceCheckingMode namespaceMode = NamespaceCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.namespace-mode"));
        CrlCheckingMode crlCheckingMode = CrlCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.crl-mode"));
        OCSPCheckingMode ocspCheckingMode = OCSPCheckingMode.valueOf((String)properties.getProperty("xrootd.gsi.ca.ocsp-mode"));
        ValidatorParams validatorParams = new ValidatorParams(new RevocationParameters(crlCheckingMode, new OCSPParametes(ocspCheckingMode)), ProxySupport.ALLOW);
        this.certChainValidator = new OpensslCertChainValidator(this.caCertificatePath, false, namespaceMode, this.trustAnchorRefreshInterval, validatorParams, false);
    }

    public X509CertChainValidator getCertChainValidator() {
        return this.certChainValidator;
    }
}

