/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.DHBufferHandler;
import org.dcache.xrootd.plugins.authn.gsi.DHSession;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.RSASession;
import org.dcache.xrootd.security.NestedBucketBuffer;
import org.dcache.xrootd.security.RawBucket;
import org.dcache.xrootd.security.StringBucket;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GSIRequestHandler {
    protected static Logger LOGGER = LoggerFactory.getLogger(GSIRequestHandler.class);
    public static final String PROTOCOL = "gsi";
    public static final int PROTO_WITH_DELEGATION = 10400;
    public static final int PROTO_PRE_DELEGATION = 10300;
    public static final int PROTOCOL_VERSION = 10400;
    public static final String CRYPTO_MODE = "ssl";
    public static final String CRYPTO_MODE_NO_PAD = "sslnopad";
    public static final String SUPPORTED_CIPHER_ALGORITHM = "aes-128-cbc";
    public static final String SUPPORTED_DIGESTS = "sha1:md5";
    public static final String ASYNC_CIPHER_MODE = "RSA/NONE/PKCS1Padding";
    public static final String SYNC_CIPHER_MODE_PADDED = "AES/CBC/PKCS5Padding";
    public static final String SYNC_CIPHER_MODE_UNPADDED = "AES/CBC/NoPadding";
    public static final String SYNC_CIPHER_NAME = "AES";
    public static final String PUBLIC_KEY_ALGORITHM = "RSA";
    public static final String PUBLIC_KEY_HEADER = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_KEY_FOOTER = "-----END PUBLIC KEY-----";
    public static final int SYNC_CIPHER_BLOCKSIZE = 16;
    public static final int CHALLENGE_BYTES = 8;
    public static final long MAX_TIME_SKEW = TimeUnit.SECONDS.toMillis(300L);
    public static final String SESSION_IV_DELIM = "#";
    public static final int SESSION_IV_LEN = 16;
    protected static final SecureRandom RANDOM = new SecureRandom();
    protected final GSICredentialManager credentialManager;
    protected DHSession dhSession;
    protected RSASession rsaSession;
    protected DHBufferHandler bufferHandler;
    protected String challenge = "";
    protected long lastRequest;
    protected boolean noPadding;

    protected static int findSessionIVLen(String cipher) throws XrootdException {
        int index = cipher.indexOf(SESSION_IV_DELIM);
        if (index == cipher.length() - 1) {
            throw new XrootdException(10026, "malformed cipher " + cipher);
        }
        return index < 0 ? 0 : Integer.valueOf(cipher.substring(index + 1));
    }

    public static String generateChallengeString() {
        byte[] challengeBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            challengeBytes[i] = (byte)RANDOM.nextInt(127);
        }
        String challenge = new String(challengeBytes, StandardCharsets.US_ASCII);
        LOGGER.debug("Generated new challenge string: {}.", (Object)challenge);
        return challenge;
    }

    protected GSIRequestHandler(GSICredentialManager credentialManager) {
        this.credentialManager = credentialManager;
        this.rsaSession = new RSASession();
    }

    public abstract int getProtocolVersion();

    protected abstract String getSyncCipherMode();

    protected NestedBucketBuffer decryptMainBucketWithSessionKey(Map<XrootdSecurityProtocol.BucketType, XrootdBucket> receivedBuckets, String step) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeyException, IOException, XrootdException {
        LOGGER.debug("Decrypting main bucket with session key.");
        RawBucket encryptedBucket = (RawBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_main);
        byte[] encrypted = encryptedBucket.getContent();
        byte[] decrypted = this.dhSession.decrypt(SYNC_CIPHER_MODE_PADDED, SYNC_CIPHER_NAME, 16, encrypted);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])decrypted);
        NestedBucketBuffer nested = NestedBucketBuffer.deserialize((XrootdSecurityProtocol.BucketType)XrootdSecurityProtocol.BucketType.kXRS_main, (ByteBuf)buffer);
        if (LOGGER.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            nested.dump(builder, step, 0);
            LOGGER.trace(builder.toString());
        }
        return nested;
    }

    protected byte[] dhParams(boolean sign) throws IOException, BadPaddingException, IllegalBlockSizeException {
        LOGGER.debug("Getting encoded dh paramters (signed: {}).", (Object)sign);
        byte[] cipher = this.dhSession.getEncodedDHMaterial().getBytes();
        if (sign) {
            LOGGER.debug("Signing encoded dh paramters.");
            return this.rsaSession.encrypt(cipher);
        }
        return cipher;
    }

    protected X509Certificate[] extractChain(Map<XrootdSecurityProtocol.BucketType, XrootdBucket> nestedBuckets) throws XrootdException, IOException {
        LOGGER.debug("Extracting X509Certificate chain.");
        XrootdBucket clientX509Bucket = nestedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_x509);
        if (clientX509Bucket == null) {
            throw new XrootdException(10001, "No kXRS_x509 bucket.");
        }
        String clientX509 = ((StringBucket)clientX509Bucket).getContent();
        ByteArrayInputStream stream = new ByteArrayInputStream(clientX509.getBytes(StandardCharsets.US_ASCII));
        X509Certificate[] proxyCertChain = CertificateUtils.loadCertificateChain((InputStream)stream, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        if (proxyCertChain.length == 0) {
            throw new IllegalArgumentException("Could not parse x509 certificate from input stream!");
        }
        return proxyCertChain;
    }

    protected void finalizeSessionKey(Map<XrootdSecurityProtocol.BucketType, XrootdBucket> receivedBuckets, XrootdSecurityProtocol.BucketType bucketType) throws IOException, GeneralSecurityException, XrootdException {
        LOGGER.debug("Finalizing session key using bucket type {}.", (Object)bucketType.name());
        StringBucket dhMessage = null;
        switch (bucketType) {
            case kXRS_puk: {
                dhMessage = (StringBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_puk);
                LOGGER.debug("DH message (params) from kXRS_puk: {}.", (Object)dhMessage.getContent());
                break;
            }
            case kXRS_cipher: {
                RawBucket encryptedBucket = (RawBucket)receivedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_cipher);
                byte[] encrypted = encryptedBucket.getContent();
                LOGGER.debug("Decrypting cipher bucket using public key, buffer length {}.", (Object)encrypted.length);
                byte[] decrypted = this.rsaSession.decrypt(encrypted);
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])decrypted);
                dhMessage = StringBucket.deserialize((XrootdSecurityProtocol.BucketType)XrootdSecurityProtocol.BucketType.kXRS_cipher, (ByteBuf)buffer);
                LOGGER.debug("DH message (params) from kXRS_cipher after decryption: {}.", (Object)dhMessage.getContent());
                break;
            }
            default: {
                throw new XrootdException(10004, "Unexpected bucketType " + bucketType + " in finalizeSessionKey: " + bucketType.name());
            }
        }
        this.dhSession.finaliseKeyAgreement(dhMessage.getContent());
        this.bufferHandler = new DHBufferHandler(this.dhSession, this.getSyncCipherMode(), SYNC_CIPHER_NAME, 16);
        LOGGER.debug("Constructed buffer handler for signed hash use.");
    }

    protected boolean isRequestExpired() {
        if (this.lastRequest == 0L) {
            this.lastRequest = System.currentTimeMillis();
            return false;
        }
        return System.currentTimeMillis() - this.lastRequest >= MAX_TIME_SKEW;
    }

    protected XrootdBucket postProcessMainBucket(Map<XrootdSecurityProtocol.BucketType, XrootdBucket> buckets, Optional<String> serializedX509, int step) throws BadPaddingException, IllegalBlockSizeException, NoSuchProviderException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, XrootdException, IOException {
        LOGGER.debug("Post-processing main bucket.");
        this.challenge = GSIRequestHandler.generateChallengeString();
        byte[] signedRtag = this.signRtagChallenge(buckets);
        RawBucket signedRtagBucket = new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag, signedRtag);
        StringBucket randomTagBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_rtag, this.challenge);
        XrootdSecurityProtocol.BucketType x509Type = step == 2002 ? XrootdSecurityProtocol.BucketType.kXRS_x509_req : XrootdSecurityProtocol.BucketType.kXRS_x509;
        StringBucket x509Bucket = serializedX509.isPresent() ? new StringBucket(x509Type, serializedX509.get()) : null;
        switch (step) {
            case 1001: 
            case 1002: 
            case 2002: {
                LOGGER.debug("Building encrypted main bucket.");
                return this.buildEncryptedMainBucket(step, new XrootdBucket[]{signedRtagBucket, randomTagBucket, x509Bucket});
            }
        }
        LOGGER.debug("Building unencrypted main bucket.");
        EnumMap<XrootdSecurityProtocol.BucketType, Object> nestedBuckets = new EnumMap<XrootdSecurityProtocol.BucketType, Object>(XrootdSecurityProtocol.BucketType.class);
        nestedBuckets.put(signedRtagBucket.getType(), (Object)signedRtagBucket);
        nestedBuckets.put(randomTagBucket.getType(), (Object)randomTagBucket);
        if (x509Bucket != null) {
            nestedBuckets.put(x509Bucket.getType(), (Object)x509Bucket);
        }
        return new NestedBucketBuffer(XrootdSecurityProtocol.BucketType.kXRS_main, PROTOCOL, step, nestedBuckets);
    }

    protected X509Certificate[] processRSAVerification(Map<XrootdSecurityProtocol.BucketType, XrootdBucket> nestedBuckets, Optional<PublicKey> toMatch) throws InvalidKeyException, IOException, XrootdException {
        LOGGER.debug("Processing RSA cert chain verification; previous key to match? {}.", (Object)toMatch.isPresent());
        X509Certificate[] proxyCertChain = this.extractChain(nestedBuckets);
        this.credentialManager.getCertChainValidator().validate(proxyCertChain);
        X509Certificate certificate = proxyCertChain[0];
        if (toMatch.isPresent() && !toMatch.get().equals(certificate.getPublicKey())) {
            throw new InvalidKeyException("Error in cryptographic operations; received two different public keys.");
        }
        return proxyCertChain;
    }

    protected void updateLastRequest() {
        this.lastRequest = System.currentTimeMillis();
    }

    protected String validateCiphers(String[] algorithms) throws XrootdException {
        LOGGER.debug("Validating cipher algorithm.");
        String selectedCipher = null;
        for (String algorithm : algorithms) {
            LOGGER.debug("checking cipher algorithm {}.", (Object)algorithm);
            int ivIndex = algorithm.indexOf(SESSION_IV_DELIM);
            String cipher = ivIndex > 0 ? algorithm.substring(0, ivIndex) : algorithm;
            if (!SUPPORTED_CIPHER_ALGORITHM.contains(cipher)) continue;
            selectedCipher = algorithm;
            break;
        }
        if (selectedCipher == null) {
            throw new XrootdException(4003, "all sender ciphers are unsupported: " + Arrays.asList(algorithms));
        }
        LOGGER.debug("Selected cipher algorithm {}", selectedCipher);
        return selectedCipher;
    }

    protected void validateCryptoMode(String cryptoMode) throws XrootdException {
        LOGGER.debug("Validating crypto mode.");
        if (!cryptoMode.equalsIgnoreCase(CRYPTO_MODE)) {
            if (cryptoMode.equalsIgnoreCase(CRYPTO_MODE_NO_PAD)) {
                this.noPadding = true;
                return;
            }
            throw new XrootdException(4003, cryptoMode + " not supported.");
        }
    }

    protected String validateDigests(String[] digests) throws XrootdException {
        LOGGER.debug("Validating cipher digests.");
        String selectedDigest = null;
        for (String digest : digests) {
            if (!SUPPORTED_DIGESTS.contains(digest)) continue;
            selectedDigest = digest;
            break;
        }
        if (selectedDigest == null) {
            throw new XrootdException(4003, "all sender digests are unsupported: " + Arrays.asList(digests));
        }
        return selectedDigest;
    }

    protected void verifySignedRTag(Map<XrootdSecurityProtocol.BucketType, XrootdBucket> nestedBuckets) throws XrootdException, BadPaddingException, IllegalBlockSizeException, IOException {
        XrootdBucket signedRTagBucket = nestedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_signed_rtag);
        byte[] signedRTag = ((RawBucket)signedRTagBucket).getContent();
        byte[] rTag = this.rsaSession.decrypt(signedRTag);
        String rTagString = new String(rTag, StandardCharsets.US_ASCII);
        if (!this.challenge.equals(rTagString)) {
            LOGGER.error("The challenge is {}, the serialized rTag is {}.signature of challenge tag has been proven wrong!!", (Object)this.challenge, (Object)rTagString);
            throw new XrootdException(10011, "Sender did not present correctchallenge response!");
        }
        LOGGER.debug("signature of challenge tag ok. Challenge: {}, rTagString: {}", (Object)this.challenge, (Object)rTagString);
    }

    private RawBucket buildEncryptedMainBucket(int step, XrootdBucket ... buckets) throws XrootdException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeyException {
        if (this.dhSession == null) {
            throw new XrootdException(3023, "trying to encrypt message without session key.");
        }
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        byte[] bytes = PROTOCOL.getBytes(StandardCharsets.US_ASCII);
        buffer.writeBytes(bytes);
        buffer.writeZero(4 - bytes.length);
        buffer.writeInt(step);
        for (XrootdBucket bucket : buckets) {
            if (bucket == null) continue;
            bucket.serialize(buffer);
        }
        buffer.writeInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
        byte[] raw = new byte[buffer.readableBytes()];
        buffer.getBytes(0, raw);
        buffer.release();
        byte[] encrypted = this.dhSession.encrypt(SYNC_CIPHER_MODE_PADDED, SYNC_CIPHER_NAME, 16, raw);
        return new RawBucket(XrootdSecurityProtocol.BucketType.kXRS_main, encrypted);
    }

    private byte[] signRtagChallenge(Map<XrootdSecurityProtocol.BucketType, XrootdBucket> nestedBuckets) throws BadPaddingException, IllegalBlockSizeException, IOException {
        StringBucket rtagBucket = (StringBucket)nestedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_rtag);
        byte[] rtag = rtagBucket.getContent().getBytes();
        LOGGER.debug("Signing sender's random challenge tag of length {}.", (Object)rtag.length);
        return this.rsaSession.encrypt(rtag);
    }
}

