/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.Optional;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.GSIClientRequestHandler;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.post49.GSIPost49ClientRequestHandler;
import org.dcache.xrootd.plugins.authn.gsi.pre49.GSIPre49ClientRequestHandler;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.dcache.xrootd.tpc.AbstractClientAuthnHandler;
import org.dcache.xrootd.tpc.XrootdTpcClient;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.InboundErrorResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundAuthenticationRequest;

public class GSIClientAuthenticationHandler
extends AbstractClientAuthnHandler {
    private GSICredentialManager credentialManager;
    private GSIClientRequestHandler requestHandler;
    private int serverStep;

    public GSIClientAuthenticationHandler(GSICredentialManager credentialManager) {
        super("gsi");
        this.credentialManager = credentialManager;
    }

    public void setClient(XrootdTpcClient client) {
        super.setClient(client);
    }

    protected void doOnErrorResponse(ChannelHandlerContext ctx, InboundErrorResponse response) throws XrootdException {
        if (this.requestHandler != null) {
            this.requestHandler.handleAuthenticationError(response);
        } else {
            XrootdException throwable = new XrootdException(response.getError(), response.getErrorMessage());
            this.exceptionCaught(ctx, new RuntimeException("An authentication error was  intercepted before an authentication request was sent; this is a bug.", (Throwable)throwable));
        }
    }

    protected void doOnAuthenticationResponse(ChannelHandlerContext ctx, InboundAuthenticationResponse response) throws XrootdException {
        if (this.requestHandler.isRequestExpired()) {
            throw new XrootdException(3006, "Authentication request response time expired.");
        }
        this.serverStep = response.getServerStep();
        ChannelId id = ctx.channel().id();
        int status = response.getStatus();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        switch (status) {
            case 0: {
                LOGGER.debug("Authentication to {}, channel {}, stream {}, sessionId {} succeeded; passing to next handler.", new Object[]{tpcInfo.getSrc(), id, streamId, this.client.getSessionId()});
                ctx.fireChannelRead((Object)response);
                break;
            }
            case 4002: {
                LOGGER.debug("Authentication to {}, channel {}, stream {}, sessionId {}, proceeding to next step.", new Object[]{tpcInfo.getSrc(), id, streamId, this.client.getSessionId()});
                this.client.setAuthResponse(response);
                this.sendAuthenticationRequest(ctx);
                break;
            }
            default: {
                throw new XrootdException(10015, "wrong status from GSI authentication response: " + status);
            }
        }
    }

    protected void sendAuthenticationRequest(ChannelHandlerContext ctx) throws XrootdException {
        OutboundAuthenticationRequest request;
        block6: {
            XrootdTpcInfo tpcInfo;
            int streamId;
            ChannelId id;
            block5: {
                if (this.requestHandler == null) {
                    this.requestHandler = this.createRequestHandler();
                }
                id = ctx.channel().id();
                streamId = this.client.getStreamId();
                tpcInfo = this.client.getInfo();
                InboundAuthenticationResponse response = this.client.getAuthResponse();
                if (response == null) break block5;
                if (!response.getProtocol().equals("gsi")) {
                    throw new XrootdException(10003, "server replied with incorrect protocol: " + response.getProtocol());
                }
                switch (this.serverStep) {
                    case 2001: {
                        request = this.requestHandler.handleCertStep(response, ctx);
                        LOGGER.debug("sendAuthenticationRequest to {}, channel {}, stream {}, step: cert.", new Object[]{tpcInfo.getSrc(), id, streamId});
                        break block6;
                    }
                    default: {
                        throw new XrootdException(10015, "client does not handle requested authentication step " + XrootdSecurityProtocol.getServerStep((int)this.serverStep) + ".");
                    }
                }
            }
            request = this.requestHandler.handleCertReqStep();
            LOGGER.debug("sendAuthenticationRequest to {}, channel {}, stream {}, step: cert request.", new Object[]{tpcInfo.getSrc(), id, streamId});
        }
        this.requestHandler.updateLastRequest();
        this.client.setExpectedResponse(3000);
        this.client.setAuthResponse(null);
        ctx.writeAndFlush((Object)request, ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        this.client.startTimer(ctx);
    }

    private GSIClientRequestHandler createRequestHandler() throws XrootdException {
        GSIClientRequestHandler handler;
        String serverVersion = ((Optional)this.client.getAuthnContext().get("version")).orElse(null);
        if (serverVersion == null) {
            throw new XrootdException(10003, "Server did not indicate GSI protocol version.");
        }
        int versionToMatch = Integer.parseInt(serverVersion);
        Serializable proxy = this.client.getInfo().getDelegatedProxy();
        if (versionToMatch >= 10400 && proxy != null) {
            handler = new GSIPost49ClientRequestHandler(this.credentialManager, this.client);
        } else if (!this.credentialManager.isDelegationOnly()) {
            handler = new GSIPre49ClientRequestHandler(this.credentialManager, this.client);
        } else {
            throw new XrootdException(10026, "proxy delegation required but not available.");
        }
        LOGGER.info("Server protocol version was {}; delegated proxy exists? {}; using {}.", new Object[]{versionToMatch, proxy != null, handler.getClass().getSimpleName()});
        return handler;
    }
}

