/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import io.netty.buffer.ByteBuf;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucket;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketUtils;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class RawBucket
extends GSIBucket {
    private final byte[] _data;

    public RawBucket(XrootdSecurityProtocol.BucketType type, byte[] data) {
        super(type);
        this._data = data;
    }

    @Override
    public int dump(StringBuilder builder, String step, int number) {
        super.dump(builder, step, number);
        builder.append("//\n");
        builder.append("//                  RAW BYTE CONTENTS                  //\n");
        builder.append("//\n");
        GSIBucketUtils.dumpBytes(builder, this._data);
        return number;
    }

    public byte[] getContent() {
        return this._data;
    }

    public static RawBucket deserialize(XrootdSecurityProtocol.BucketType type, ByteBuf buffer) {
        byte[] tmp = new byte[buffer.readableBytes()];
        buffer.getBytes(0, tmp);
        return new RawBucket(type, tmp);
    }

    @Override
    public void serialize(ByteBuf out) {
        super.serialize(out);
        out.writeInt(this._data.length);
        out.writeBytes(this._data);
    }

    @Override
    public int getSize() {
        return super.getSize() + 4 + this._data.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " hex dump:");
        for (byte b : this._data) {
            sb.append(" ").append(Integer.toHexString(b));
        }
        return sb.toString();
    }
}

