/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.util.ArrayList;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucket;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GSIBucketContainerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSIBucketContainerBuilder.class);

    public static GSIBucketContainer build(GSIBucket ... buckets) {
        int responseLength = 0;
        ArrayList<GSIBucket> responseList = new ArrayList<GSIBucket>();
        for (GSIBucket bucket : buckets) {
            if (bucket == null) continue;
            responseList.add(bucket);
            LOGGER.trace("added bucket {} of size {}; response length is now {}.", new Object[]{bucket.getType(), bucket.getSize(), responseLength += bucket.getSize()});
        }
        return new GSIBucketContainer(responseList, responseLength);
    }

    public abstract GSIBucketContainer buildContainer();
}

