/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import org.dcache.xrootd.core.XrootdEncoder;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedBucketBuffer
extends GSIBucket {
    private static final Logger _logger = LoggerFactory.getLogger(NestedBucketBuffer.class);
    private final Map<XrootdSecurityProtocol.BucketType, GSIBucket> _nestedBuckets;
    private final String _protocol;
    private final int _step;

    public NestedBucketBuffer(XrootdSecurityProtocol.BucketType type, String protocol, int step, Map<XrootdSecurityProtocol.BucketType, GSIBucket> nestedBuckets) {
        super(type);
        this._protocol = protocol;
        this._step = step;
        this._nestedBuckets = nestedBuckets;
    }

    @Override
    public int dump(StringBuilder builder, String step, int number) {
        super.dump(builder, step, number);
        builder.append("//........................NESTED.........................\n");
        int i = number;
        Collection<GSIBucket> buckets = this._nestedBuckets.values();
        for (GSIBucket bucket : buckets) {
            ++i;
            i = bucket.dump(builder, step, i);
        }
        builder.append("//\n");
        builder.append("//......................END NESTED.......................\n");
        return i;
    }

    public Map<XrootdSecurityProtocol.BucketType, GSIBucket> getNestedBuckets() {
        return this._nestedBuckets;
    }

    public int getStep() {
        return this._step;
    }

    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public void serialize(ByteBuf out) {
        super.serialize(out);
        int start = out.writerIndex();
        out.writeInt(0);
        XrootdEncoder.writeZeroPad((String)this._protocol, (ByteBuf)out, (int)4);
        out.writeInt(this._step);
        for (GSIBucket bucket : this._nestedBuckets.values()) {
            bucket.serialize(out);
        }
        out.writeInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
        out.setInt(start, out.writerIndex() - start - 4);
    }

    @Override
    public int getSize() {
        int size = super.getSize() + 4 + 4 + 4;
        for (GSIBucket bucket : this._nestedBuckets.values()) {
            size += bucket.getSize();
        }
        return size + 4;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("begin nested BucketBuffer\n");
        for (GSIBucket bucket : this._nestedBuckets.values()) {
            sb.append(bucket.toString());
        }
        sb.append("end nested BucketBuffer\n");
        return sb.toString();
    }
}

